// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package docdb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of CreateDBClusterParameterGroup.
type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	//
	// Constraints:
	//
	//    * Must not match the name of an existing DBClusterParameterGroup.
	//
	// This value is stored as a lowercase string.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The cluster parameter group family name.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the cluster parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The tags to be assigned to the cluster parameter group.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterParameterGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDBClusterParameterGroupInput"}

	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBParameterGroupFamily"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster parameter group.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest returns a request value for making API operation for
// Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new cluster parameter group.
//
// Parameters in a cluster parameter group apply to all of the instances in
// a DB cluster.
//
// A cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the cluster. To provide custom
// values for any of the parameters, you must modify the group after you create
// it. After you create a DB cluster parameter group, you must associate it
// with your cluster. For the new DB cluster parameter group and associated
// settings to take effect, you must then reboot the instances in the cluster
// without failover.
//
// After you create a cluster parameter group, you should wait at least 5 minutes
// before creating your first cluster that uses that cluster parameter group
// as the default parameter group. This allows Amazon DocumentDB to fully complete
// the create action before the cluster parameter group is used as the default
// for a new cluster. This step is especially important for parameters that
// are critical when creating the default database for a cluster, such as the
// character set for the default database defined by the character_set_database
// parameter.
//
//    // Example sending a request using CreateDBClusterParameterGroupRequest.
//    req := client.CreateDBClusterParameterGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup
func (c *Client) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) CreateDBClusterParameterGroupRequest {
	op := &aws.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	req := c.newRequest(op, input, &CreateDBClusterParameterGroupOutput{})

	return CreateDBClusterParameterGroupRequest{Request: req, Input: input, Copy: c.CreateDBClusterParameterGroupRequest}
}

// CreateDBClusterParameterGroupRequest is the request type for the
// CreateDBClusterParameterGroup API operation.
type CreateDBClusterParameterGroupRequest struct {
	*aws.Request
	Input *CreateDBClusterParameterGroupInput
	Copy  func(*CreateDBClusterParameterGroupInput) CreateDBClusterParameterGroupRequest
}

// Send marshals and sends the CreateDBClusterParameterGroup API request.
func (r CreateDBClusterParameterGroupRequest) Send(ctx context.Context) (*CreateDBClusterParameterGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDBClusterParameterGroupResponse{
		CreateDBClusterParameterGroupOutput: r.Request.Data.(*CreateDBClusterParameterGroupOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDBClusterParameterGroupResponse is the response type for the
// CreateDBClusterParameterGroup API operation.
type CreateDBClusterParameterGroupResponse struct {
	*CreateDBClusterParameterGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDBClusterParameterGroup request.
func (r *CreateDBClusterParameterGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
