// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return per page.
	MaxResults *int64 `type:"integer"`

	// A token to for the desired page, if there is one.
	NextToken *string `type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContributorInsightsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListContributorInsightsInput"}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ContributorInsightsSummary.
	ContributorInsightsSummaries []ContributorInsightsSummary `type:"list"`

	// A token to go to the next page if there is one.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListContributorInsights = "ListContributorInsights"

// ListContributorInsightsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Returns a list of ContributorInsightsSummary for a table and all its global
// secondary indexes.
//
//    // Example sending a request using ListContributorInsightsRequest.
//    req := client.ListContributorInsightsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights
func (c *Client) ListContributorInsightsRequest(input *ListContributorInsightsInput) ListContributorInsightsRequest {
	op := &aws.Operation{
		Name:       opListContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContributorInsightsInput{}
	}

	req := c.newRequest(op, input, &ListContributorInsightsOutput{})

	return ListContributorInsightsRequest{Request: req, Input: input, Copy: c.ListContributorInsightsRequest}
}

// ListContributorInsightsRequest is the request type for the
// ListContributorInsights API operation.
type ListContributorInsightsRequest struct {
	*aws.Request
	Input *ListContributorInsightsInput
	Copy  func(*ListContributorInsightsInput) ListContributorInsightsRequest
}

// Send marshals and sends the ListContributorInsights API request.
func (r ListContributorInsightsRequest) Send(ctx context.Context) (*ListContributorInsightsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListContributorInsightsResponse{
		ListContributorInsightsOutput: r.Request.Data.(*ListContributorInsightsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListContributorInsightsRequestPaginator returns a paginator for ListContributorInsights.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListContributorInsightsRequest(input)
//   p := dynamodb.NewListContributorInsightsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListContributorInsightsPaginator(req ListContributorInsightsRequest) ListContributorInsightsPaginator {
	return ListContributorInsightsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListContributorInsightsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListContributorInsightsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListContributorInsightsPaginator struct {
	aws.Pager
}

func (p *ListContributorInsightsPaginator) CurrentPage() *ListContributorInsightsOutput {
	return p.Pager.CurrentPage().(*ListContributorInsightsOutput)
}

// ListContributorInsightsResponse is the response type for the
// ListContributorInsights API operation.
type ListContributorInsightsResponse struct {
	*ListContributorInsightsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListContributorInsights request.
func (r *ListContributorInsightsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
