// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RestoreTableToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The billing mode of the restored table.
	BillingModeOverride BillingMode `type:"string" enum:"true"`

	// List of global secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	GlobalSecondaryIndexOverride []GlobalSecondaryIndex `type:"list"`

	// List of local secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	LocalSecondaryIndexOverride []LocalSecondaryIndex `type:"list"`

	// Provisioned throughput settings for the restored table.
	ProvisionedThroughputOverride *ProvisionedThroughput `type:"structure"`

	// Time in the past to restore the table to.
	RestoreDateTime *time.Time `type:"timestamp"`

	// The new server-side encryption settings for the restored table.
	SSESpecificationOverride *SSESpecification `type:"structure"`

	// The DynamoDB table that will be restored. This value is an Amazon Resource
	// Name (ARN).
	SourceTableArn *string `type:"string"`

	// Name of the source table that is being restored.
	SourceTableName *string `min:"3" type:"string"`

	// The name of the new table to which it must be restored to.
	//
	// TargetTableName is a required field
	TargetTableName *string `min:"3" type:"string" required:"true"`

	// Restore the table to the latest possible time. LatestRestorableDateTime is
	// typically 5 minutes before the current time.
	UseLatestRestorableTime *bool `type:"boolean"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableToPointInTimeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreTableToPointInTimeInput"}
	if s.SourceTableName != nil && len(*s.SourceTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceTableName", 3))
	}

	if s.TargetTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetTableName", 3))
	}
	if s.GlobalSecondaryIndexOverride != nil {
		for i, v := range s.GlobalSecondaryIndexOverride {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexOverride", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexOverride != nil {
		for i, v := range s.LocalSecondaryIndexOverride {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexOverride", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestoreTableToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of a table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreTableToPointInTime = "RestoreTableToPointInTime"

// RestoreTableToPointInTimeRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Restores the specified table to the specified point in time within EarliestRestorableDateTime
// and LatestRestorableDateTime. You can restore your table to any point in
// time during the last 35 days. Any number of users can execute up to 4 concurrent
// restores (any type of restore) in a given account.
//
// When you restore using point in time recovery, DynamoDB restores your table
// data to the state based on the selected date and time (day:hour:minute:second)
// to a new table.
//
// Along with data, the following are also included on the new restored table
// using point in time recovery:
//
//    * Global secondary indexes (GSIs)
//
//    * Local secondary indexes (LSIs)
//
//    * Provisioned read and write capacity
//
//    * Encryption settings All these settings come from the current settings
//    of the source table at the time of restore.
//
// You must manually set up the following on the restored table:
//
//    * Auto scaling policies
//
//    * IAM policies
//
//    * Amazon CloudWatch metrics and alarms
//
//    * Tags
//
//    * Stream settings
//
//    * Time to Live (TTL) settings
//
//    * Point in time recovery settings
//
//    // Example sending a request using RestoreTableToPointInTimeRequest.
//    req := client.RestoreTableToPointInTimeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime
func (c *Client) RestoreTableToPointInTimeRequest(input *RestoreTableToPointInTimeInput) RestoreTableToPointInTimeRequest {
	op := &aws.Operation{
		Name:       opRestoreTableToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableToPointInTimeInput{}
	}

	req := c.newRequest(op, input, &RestoreTableToPointInTimeOutput{})

	if req.Config.EnableEndpointDiscovery {
		de := discovererDescribeEndpoints{
			Client:        c,
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": &req.Operation.Name,
			},
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(aws.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}

	return RestoreTableToPointInTimeRequest{Request: req, Input: input, Copy: c.RestoreTableToPointInTimeRequest}
}

// RestoreTableToPointInTimeRequest is the request type for the
// RestoreTableToPointInTime API operation.
type RestoreTableToPointInTimeRequest struct {
	*aws.Request
	Input *RestoreTableToPointInTimeInput
	Copy  func(*RestoreTableToPointInTimeInput) RestoreTableToPointInTimeRequest
}

// Send marshals and sends the RestoreTableToPointInTime API request.
func (r RestoreTableToPointInTimeRequest) Send(ctx context.Context) (*RestoreTableToPointInTimeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreTableToPointInTimeResponse{
		RestoreTableToPointInTimeOutput: r.Request.Data.(*RestoreTableToPointInTimeOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreTableToPointInTimeResponse is the response type for the
// RestoreTableToPointInTime API operation.
type RestoreTableToPointInTimeResponse struct {
	*RestoreTableToPointInTimeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreTableToPointInTime request.
func (r *RestoreTableToPointInTimeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
