// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CompleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The number of blocks that were written to the snapshot.
	//
	// ChangedBlocksCount is a required field
	ChangedBlocksCount *int64 `location:"header" locationName:"x-amz-ChangedBlocksCount" type:"integer" required:"true"`

	// An aggregated Base-64 SHA256 checksum based on the checksums of each written
	// block.
	//
	// To generate the aggregated checksum using the linear aggregation method,
	// arrange the checksums for each written block in ascending order of their
	// block index, concatenate them to form a single string, and then generate
	// the checksum on the entire string using the SHA256 algorithm.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The aggregation method used to generate the checksum. Currently, the only
	// supported aggregation method is LINEAR.
	ChecksumAggregationMethod ChecksumAggregationMethod `location:"header" locationName:"x-amz-Checksum-Aggregation-Method" type:"string" enum:"true"`

	// The algorithm used to generate the checksum. Currently, the only supported
	// algorithm is SHA256.
	ChecksumAlgorithm ChecksumAlgorithm `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"true"`

	// The ID of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteSnapshotInput"}

	if s.ChangedBlocksCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangedBlocksCount"))
	}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteSnapshotInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChangedBlocksCount != nil {
		v := *s.ChangedBlocksCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-ChangedBlocksCount", protocol.Int64Value(v), metadata)
	}
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChecksumAggregationMethod) > 0 {
		v := s.ChecksumAggregationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum-Aggregation-Method", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ChecksumAlgorithm) > 0 {
		v := s.ChecksumAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum-Algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "snapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CompleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The status of the snapshot.
	Status Status `type:"string" enum:"true"`
}

// String returns the string representation
func (s CompleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteSnapshotOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opCompleteSnapshot = "CompleteSnapshot"

// CompleteSnapshotRequest returns a request value for making API operation for
// Amazon Elastic Block Store.
//
// Seals and completes the snapshot after all of the required blocks of data
// have been written to it. Completing the snapshot changes the status to completed.
// You cannot write new blocks to a snapshot after it has been completed.
//
//    // Example sending a request using CompleteSnapshotRequest.
//    req := client.CompleteSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/CompleteSnapshot
func (c *Client) CompleteSnapshotRequest(input *CompleteSnapshotInput) CompleteSnapshotRequest {
	op := &aws.Operation{
		Name:       opCompleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/snapshots/completion/{snapshotId}",
	}

	if input == nil {
		input = &CompleteSnapshotInput{}
	}

	req := c.newRequest(op, input, &CompleteSnapshotOutput{})

	return CompleteSnapshotRequest{Request: req, Input: input, Copy: c.CompleteSnapshotRequest}
}

// CompleteSnapshotRequest is the request type for the
// CompleteSnapshot API operation.
type CompleteSnapshotRequest struct {
	*aws.Request
	Input *CompleteSnapshotInput
	Copy  func(*CompleteSnapshotInput) CompleteSnapshotRequest
}

// Send marshals and sends the CompleteSnapshot API request.
func (r CompleteSnapshotRequest) Send(ctx context.Context) (*CompleteSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CompleteSnapshotResponse{
		CompleteSnapshotOutput: r.Request.Data.(*CompleteSnapshotOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CompleteSnapshotResponse is the response type for the
// CompleteSnapshot API operation.
type CompleteSnapshotResponse struct {
	*CompleteSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CompleteSnapshot request.
func (r *CompleteSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
