// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully.
	// The subsequent retries with the same client token return the result from
	// the original successful request and they have no additional effect.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	//
	// For more information, see Idempotency for StartSnapshot API (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// A description for the snapshot.
	Description *string `type:"string"`

	// Indicates whether to encrypt the snapshot. To create an encrypted snapshot,
	// specify true. To create an unencrypted snapshot, omit this parameter.
	//
	// If you specify a value for ParentSnapshotId, omit this parameter.
	//
	// If you specify true, the snapshot is encrypted using the CMK specified using
	// the KmsKeyArn parameter. If no value is specified for KmsKeyArn, the default
	// CMK for your account is used. If no default CMK has been specified for your
	// account, the AWS managed CMK is used. To set a default CMK for your account,
	// use ModifyEbsDefaultKmsKeyId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html).
	//
	// If your account is enabled for encryption by default, you cannot set this
	// parameter to false. In this case, you can omit this parameter.
	//
	// For more information, see Using encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS)
	// customer master key (CMK) to be used to encrypt the snapshot. If you do not
	// specify a CMK, the default AWS managed CMK is used.
	//
	// If you specify a ParentSnapshotId, omit this parameter; the snapshot will
	// be encrypted using the same CMK that was used to encrypt the parent snapshot.
	//
	// If Encrypted is set to true, you must specify a CMK ARN.
	KmsKeyArn *string `min:"1" type:"string" sensitive:"true"`

	// The ID of the parent snapshot. If there is no parent snapshot, or if you
	// are creating the first snapshot for an on-premises volume, omit this parameter.
	//
	// If your account is enabled for encryption by default, you cannot use an unencrypted
	// snapshot as a parent snapshot. You must first create an encrypted copy of
	// the parent snapshot using CopySnapshot (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html).
	ParentSnapshotId *string `min:"1" type:"string"`

	// The tags to apply to the snapshot.
	Tags []Tag `type:"list"`

	// The amount of time (in minutes) after which the snapshot is automatically
	// cancelled if:
	//
	//    * No blocks are written to the snapshot.
	//
	//    * The snapshot is not completed after writing the last block of data.
	//
	// If no value is specified, the timeout defaults to 60 minutes.
	Timeout *int64 `min:"10" type:"integer"`

	// The size of the volume, in GiB. The maximum size is 16384 GiB (16 TiB).
	//
	// VolumeSize is a required field
	VolumeSize *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s StartSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartSnapshotInput"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyArn", 1))
	}
	if s.ParentSnapshotId != nil && len(*s.ParentSnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentSnapshotId", 1))
	}
	if s.Timeout != nil && *s.Timeout < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 10))
	}

	if s.VolumeSize == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSize"))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartSnapshotInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encrypted != nil {
		v := *s.Encrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Encrypted", protocol.BoolValue(v), metadata)
	}
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentSnapshotId != nil {
		v := *s.ParentSnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentSnapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.VolumeSize != nil {
		v := *s.VolumeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VolumeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

type StartSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The size of the blocks in the snapshot, in bytes.
	BlockSize *int64 `type:"integer"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS)
	// customer master key (CMK) used to encrypt the snapshot.
	KmsKeyArn *string `min:"1" type:"string" sensitive:"true"`

	// The AWS account ID of the snapshot owner.
	OwnerId *string `min:"1" type:"string"`

	// The ID of the parent snapshot.
	ParentSnapshotId *string `min:"1" type:"string"`

	// The ID of the snapshot.
	SnapshotId *string `min:"1" type:"string"`

	// The timestamp when the snapshot was created.
	StartTime *time.Time `type:"timestamp"`

	// The status of the snapshot.
	Status Status `type:"string" enum:"true"`

	// The tags applied to the snapshot. You can specify up to 50 tags per snapshot.
	// For more information, see Tagging your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Tags []Tag `type:"list"`

	// The size of the volume, in GiB.
	VolumeSize *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s StartSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartSnapshotOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockSize != nil {
		v := *s.BlockSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockSize", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentSnapshotId != nil {
		v := *s.ParentSnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentSnapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SnapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VolumeSize != nil {
		v := *s.VolumeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VolumeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opStartSnapshot = "StartSnapshot"

// StartSnapshotRequest returns a request value for making API operation for
// Amazon Elastic Block Store.
//
// Creates a new Amazon EBS snapshot. The new snapshot enters the pending state
// after the request completes.
//
// After creating the snapshot, use PutSnapshotBlock (https://docs.aws.amazon.com/ebs/latest/APIReference/API_PutSnapshotBlock.html)
// to write blocks of data to the snapshot.
//
//    // Example sending a request using StartSnapshotRequest.
//    req := client.StartSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/StartSnapshot
func (c *Client) StartSnapshotRequest(input *StartSnapshotInput) StartSnapshotRequest {
	op := &aws.Operation{
		Name:       opStartSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/snapshots",
	}

	if input == nil {
		input = &StartSnapshotInput{}
	}

	req := c.newRequest(op, input, &StartSnapshotOutput{})

	return StartSnapshotRequest{Request: req, Input: input, Copy: c.StartSnapshotRequest}
}

// StartSnapshotRequest is the request type for the
// StartSnapshot API operation.
type StartSnapshotRequest struct {
	*aws.Request
	Input *StartSnapshotInput
	Copy  func(*StartSnapshotInput) StartSnapshotRequest
}

// Send marshals and sends the StartSnapshot API request.
func (r StartSnapshotRequest) Send(ctx context.Context) (*StartSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartSnapshotResponse{
		StartSnapshotOutput: r.Request.Data.(*StartSnapshotOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartSnapshotResponse is the response type for the
// StartSnapshot API operation.
type StartSnapshotResponse struct {
	*StartSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartSnapshot request.
func (r *StartSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
