// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CancelImportTaskInput struct {
	_ struct{} `type:"structure"`

	// The reason for canceling the task.
	CancelReason *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the import image or import snapshot task to be canceled.
	ImportTaskId *string `type:"string"`
}

// String returns the string representation
func (s CancelImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

type CancelImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the task being canceled.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The current state of the task being canceled.
	PreviousState *string `locationName:"previousState" type:"string"`

	// The current state of the task being canceled.
	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s CancelImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelImportTask = "CancelImportTask"

// CancelImportTaskRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Cancels an in-process import virtual machine or import snapshot task.
//
//    // Example sending a request using CancelImportTaskRequest.
//    req := client.CancelImportTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *Client) CancelImportTaskRequest(input *CancelImportTaskInput) CancelImportTaskRequest {
	op := &aws.Operation{
		Name:       opCancelImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImportTaskInput{}
	}

	req := c.newRequest(op, input, &CancelImportTaskOutput{})

	return CancelImportTaskRequest{Request: req, Input: input, Copy: c.CancelImportTaskRequest}
}

// CancelImportTaskRequest is the request type for the
// CancelImportTask API operation.
type CancelImportTaskRequest struct {
	*aws.Request
	Input *CancelImportTaskInput
	Copy  func(*CancelImportTaskInput) CancelImportTaskRequest
}

// Send marshals and sends the CancelImportTask API request.
func (r CancelImportTaskRequest) Send(ctx context.Context) (*CancelImportTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelImportTaskResponse{
		CancelImportTaskOutput: r.Request.Data.(*CancelImportTaskOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelImportTaskResponse is the response type for the
// CancelImportTask API operation.
type CancelImportTaskResponse struct {
	*CancelImportTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelImportTask request.
func (r *CancelImportTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
