// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see Ensuring Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// Indicates whether running instances should be terminated if the total target
	// capacity of the EC2 Fleet is decreased below the current size of the EC2
	// Fleet.
	ExcessCapacityTerminationPolicy FleetExcessCapacityTerminationPolicy `type:"string" enum:"true"`

	// The configuration for the EC2 Fleet.
	//
	// LaunchTemplateConfigs is a required field
	LaunchTemplateConfigs []FleetLaunchTemplateConfigRequest `locationNameList:"item" type:"list" required:"true"`

	// Describes the configuration of On-Demand Instances in an EC2 Fleet.
	OnDemandOptions *OnDemandOptionsRequest `type:"structure"`

	// Indicates whether EC2 Fleet should replace unhealthy instances.
	ReplaceUnhealthyInstances *bool `type:"boolean"`

	// Describes the configuration of Spot Instances in an EC2 Fleet.
	SpotOptions *SpotOptionsRequest `type:"structure"`

	// The key-value pair for tagging the EC2 Fleet request on creation. The value
	// for ResourceType must be fleet, otherwise the fleet request fails. To tag
	// instances at launch, specify the tags in the launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template).
	// For information about tagging after launch, see Tagging Your Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources).
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`

	// The number of units to request.
	//
	// TargetCapacitySpecification is a required field
	TargetCapacitySpecification *TargetCapacitySpecificationRequest `type:"structure" required:"true"`

	// Indicates whether running instances should be terminated when the EC2 Fleet
	// expires.
	TerminateInstancesWithExpiration *bool `type:"boolean"`

	// The type of the request. By default, the EC2 Fleet places an asynchronous
	// request for your desired capacity, and maintains it by replenishing interrupted
	// Spot Instances (maintain). A value of instant places a synchronous one-time
	// request, and returns errors for any instances that could not be launched.
	// A value of request places an asynchronous one-time request without maintaining
	// capacity or submitting requests in alternative capacity pools if capacity
	// is unavailable. For more information, see EC2 Fleet Request Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type)
	// in the Amazon Elastic Compute Cloud User Guide.
	Type FleetType `type:"string" enum:"true"`

	// The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// The default is to start fulfilling the request immediately.
	ValidFrom *time.Time `type:"timestamp"`

	// The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
	// At this point, no new EC2 Fleet requests are placed or able to fulfill the
	// request. If no value is specified, the request remains until you cancel it.
	ValidUntil *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFleetInput"}

	if s.LaunchTemplateConfigs == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchTemplateConfigs"))
	}

	if s.TargetCapacitySpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetCapacitySpecification"))
	}
	if s.LaunchTemplateConfigs != nil {
		for i, v := range s.LaunchTemplateConfigs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LaunchTemplateConfigs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TargetCapacitySpecification != nil {
		if err := s.TargetCapacitySpecification.Validate(); err != nil {
			invalidParams.AddNested("TargetCapacitySpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instances that could not be launched by the fleet.
	// Valid only when Type is set to instant.
	Errors []CreateFleetError `locationName:"errorSet" locationNameList:"item" type:"list"`

	// The ID of the EC2 Fleet.
	FleetId *string `locationName:"fleetId" type:"string"`

	// Information about the instances that were launched by the fleet. Valid only
	// when Type is set to instant.
	Instances []CreateFleetInstance `locationName:"fleetInstanceSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Launches an EC2 Fleet.
//
// You can create a single EC2 Fleet that includes multiple launch specifications
// that vary by instance type, AMI, Availability Zone, or subnet.
//
// For more information, see Launching an EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CreateFleetRequest.
//    req := client.CreateFleetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet
func (c *Client) CreateFleetRequest(input *CreateFleetInput) CreateFleetRequest {
	op := &aws.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	req := c.newRequest(op, input, &CreateFleetOutput{})

	return CreateFleetRequest{Request: req, Input: input, Copy: c.CreateFleetRequest}
}

// CreateFleetRequest is the request type for the
// CreateFleet API operation.
type CreateFleetRequest struct {
	*aws.Request
	Input *CreateFleetInput
	Copy  func(*CreateFleetInput) CreateFleetRequest
}

// Send marshals and sends the CreateFleet API request.
func (r CreateFleetRequest) Send(ctx context.Context) (*CreateFleetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFleetResponse{
		CreateFleetOutput: r.Request.Data.(*CreateFleetOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFleetResponse is the response type for the
// CreateFleet API operation.
type CreateFleetResponse struct {
	*CreateFleetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFleet request.
func (r *CreateFleetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
