// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTrafficMirrorSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to Ensure Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The description of the Traffic Mirror session.
	Description *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the source network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// The number of bytes in each packet to mirror. These are bytes after the VXLAN
	// header. Do not specify this parameter when you want to mirror the entire
	// packet. To mirror a subset of the packet, set this to the length (in bytes)
	// that you want to mirror. For example, if you set this value to 100, then
	// the first 100 bytes that meet the filter criteria are copied to the target.
	//
	// If you do not want to mirror the entire packet, use the PacketLength parameter
	// to specify the number of bytes in each packet to mirror.
	PacketLength *int64 `type:"integer"`

	// The session number determines the order in which sessions are evaluated when
	// an interface is used by multiple sessions. The first session with a matching
	// filter is the one that mirrors the packets.
	//
	// Valid values are 1-32766.
	//
	// SessionNumber is a required field
	SessionNumber *int64 `type:"integer" required:"true"`

	// The tags to assign to a Traffic Mirror session.
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`

	// The ID of the Traffic Mirror filter.
	//
	// TrafficMirrorFilterId is a required field
	TrafficMirrorFilterId *string `type:"string" required:"true"`

	// The ID of the Traffic Mirror target.
	//
	// TrafficMirrorTargetId is a required field
	TrafficMirrorTargetId *string `type:"string" required:"true"`

	// The VXLAN ID for the Traffic Mirror session. For more information about the
	// VXLAN protocol, see RFC 7348 (https://tools.ietf.org/html/rfc7348). If you
	// do not specify a VirtualNetworkId, an account-wide unique id is chosen at
	// random.
	VirtualNetworkId *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateTrafficMirrorSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficMirrorSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTrafficMirrorSessionInput"}

	if s.NetworkInterfaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkInterfaceId"))
	}

	if s.SessionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("SessionNumber"))
	}

	if s.TrafficMirrorFilterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrafficMirrorFilterId"))
	}

	if s.TrafficMirrorTargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrafficMirrorTargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTrafficMirrorSessionOutput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to Ensure Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the Traffic Mirror session.
	TrafficMirrorSession *TrafficMirrorSession `locationName:"trafficMirrorSession" type:"structure"`
}

// String returns the string representation
func (s CreateTrafficMirrorSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTrafficMirrorSession = "CreateTrafficMirrorSession"

// CreateTrafficMirrorSessionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror session.
//
// A Traffic Mirror session actively copies packets from a Traffic Mirror source
// to a Traffic Mirror target. Create a filter, and then assign it to the session
// to define a subset of the traffic to mirror, for example all TCP traffic.
//
// The Traffic Mirror source and the Traffic Mirror target (monitoring appliances)
// can be in the same VPC, or in a different VPC connected via VPC peering or
// a transit gateway.
//
// By default, no traffic is mirrored. Use CreateTrafficMirrorFilter (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm)
// to create filter rules that specify the traffic to mirror.
//
//    // Example sending a request using CreateTrafficMirrorSessionRequest.
//    req := client.CreateTrafficMirrorSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession
func (c *Client) CreateTrafficMirrorSessionRequest(input *CreateTrafficMirrorSessionInput) CreateTrafficMirrorSessionRequest {
	op := &aws.Operation{
		Name:       opCreateTrafficMirrorSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorSessionInput{}
	}

	req := c.newRequest(op, input, &CreateTrafficMirrorSessionOutput{})

	return CreateTrafficMirrorSessionRequest{Request: req, Input: input, Copy: c.CreateTrafficMirrorSessionRequest}
}

// CreateTrafficMirrorSessionRequest is the request type for the
// CreateTrafficMirrorSession API operation.
type CreateTrafficMirrorSessionRequest struct {
	*aws.Request
	Input *CreateTrafficMirrorSessionInput
	Copy  func(*CreateTrafficMirrorSessionInput) CreateTrafficMirrorSessionRequest
}

// Send marshals and sends the CreateTrafficMirrorSession API request.
func (r CreateTrafficMirrorSessionRequest) Send(ctx context.Context) (*CreateTrafficMirrorSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTrafficMirrorSessionResponse{
		CreateTrafficMirrorSessionOutput: r.Request.Data.(*CreateTrafficMirrorSessionOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTrafficMirrorSessionResponse is the response type for the
// CreateTrafficMirrorSession API operation.
type CreateTrafficMirrorSessionResponse struct {
	*CreateTrafficMirrorSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTrafficMirrorSession request.
func (r *CreateTrafficMirrorSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
