// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for CreateVpnConnection.
type CreateVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the customer gateway.
	//
	// CustomerGatewayId is a required field
	CustomerGatewayId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The options for the VPN connection.
	Options *VpnConnectionOptionsSpecification `locationName:"options" type:"structure"`

	// The ID of the transit gateway. If you specify a transit gateway, you cannot
	// specify a virtual private gateway.
	TransitGatewayId *string `type:"string"`

	// The type of VPN connection (ipsec.1).
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// The ID of the virtual private gateway. If you specify a virtual private gateway,
	// you cannot specify a transit gateway.
	VpnGatewayId *string `type:"string"`
}

// String returns the string representation
func (s CreateVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpnConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVpnConnectionInput"}

	if s.CustomerGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomerGatewayId"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateVpnConnection.
type CreateVpnConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPN connection.
	VpnConnection *VpnConnection `locationName:"vpnConnection" type:"structure"`
}

// String returns the string representation
func (s CreateVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateVpnConnection = "CreateVpnConnection"

// CreateVpnConnectionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a VPN connection between an existing virtual private gateway and
// a VPN customer gateway. The supported connection type is ipsec.1.
//
// The response includes information that you need to give to your network administrator
// to configure your customer gateway.
//
// We strongly recommend that you use HTTPS when calling this operation because
// the response contains sensitive cryptographic information for configuring
// your customer gateway.
//
// If you decide to shut down your VPN connection for any reason and later create
// a new VPN connection, you must reconfigure your customer gateway with the
// new information returned from this call.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
//    // Example sending a request using CreateVpnConnectionRequest.
//    req := client.CreateVpnConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *Client) CreateVpnConnectionRequest(input *CreateVpnConnectionInput) CreateVpnConnectionRequest {
	op := &aws.Operation{
		Name:       opCreateVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionInput{}
	}

	req := c.newRequest(op, input, &CreateVpnConnectionOutput{})

	return CreateVpnConnectionRequest{Request: req, Input: input, Copy: c.CreateVpnConnectionRequest}
}

// CreateVpnConnectionRequest is the request type for the
// CreateVpnConnection API operation.
type CreateVpnConnectionRequest struct {
	*aws.Request
	Input *CreateVpnConnectionInput
	Copy  func(*CreateVpnConnectionInput) CreateVpnConnectionRequest
}

// Send marshals and sends the CreateVpnConnection API request.
func (r CreateVpnConnectionRequest) Send(ctx context.Context) (*CreateVpnConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVpnConnectionResponse{
		CreateVpnConnectionOutput: r.Request.Data.(*CreateVpnConnectionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVpnConnectionResponse is the response type for the
// CreateVpnConnection API operation.
type CreateVpnConnectionResponse struct {
	*CreateVpnConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVpnConnection request.
func (r *CreateVpnConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
