// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLocalGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	// The CIDR range for the route. This must match the CIDR for the route exactly.
	//
	// DestinationCidrBlock is a required field
	DestinationCidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the local gateway route table.
	//
	// LocalGatewayRouteTableId is a required field
	LocalGatewayRouteTableId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLocalGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLocalGatewayRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLocalGatewayRouteInput"}

	if s.DestinationCidrBlock == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCidrBlock"))
	}

	if s.LocalGatewayRouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalGatewayRouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLocalGatewayRouteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the route.
	Route *LocalGatewayRoute `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s DeleteLocalGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLocalGatewayRoute = "DeleteLocalGatewayRoute"

// DeleteLocalGatewayRouteRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified local gateway route table.
//
//    // Example sending a request using DeleteLocalGatewayRouteRequest.
//    req := client.DeleteLocalGatewayRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute
func (c *Client) DeleteLocalGatewayRouteRequest(input *DeleteLocalGatewayRouteInput) DeleteLocalGatewayRouteRequest {
	op := &aws.Operation{
		Name:       opDeleteLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteInput{}
	}

	req := c.newRequest(op, input, &DeleteLocalGatewayRouteOutput{})

	return DeleteLocalGatewayRouteRequest{Request: req, Input: input, Copy: c.DeleteLocalGatewayRouteRequest}
}

// DeleteLocalGatewayRouteRequest is the request type for the
// DeleteLocalGatewayRoute API operation.
type DeleteLocalGatewayRouteRequest struct {
	*aws.Request
	Input *DeleteLocalGatewayRouteInput
	Copy  func(*DeleteLocalGatewayRouteInput) DeleteLocalGatewayRouteRequest
}

// Send marshals and sends the DeleteLocalGatewayRoute API request.
func (r DeleteLocalGatewayRouteRequest) Send(ctx context.Context) (*DeleteLocalGatewayRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLocalGatewayRouteResponse{
		DeleteLocalGatewayRouteOutput: r.Request.Data.(*DeleteLocalGatewayRouteOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLocalGatewayRouteResponse is the response type for the
// DeleteLocalGatewayRoute API operation.
type DeleteLocalGatewayRouteResponse struct {
	*DeleteLocalGatewayRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLocalGatewayRoute request.
func (r *DeleteLocalGatewayRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
