// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteManagedPrefixListInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the prefix list.
	//
	// PrefixListId is a required field
	PrefixListId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteManagedPrefixListInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteManagedPrefixListInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteManagedPrefixListInput"}

	if s.PrefixListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrefixListId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteManagedPrefixListOutput struct {
	_ struct{} `type:"structure"`

	// Information about the prefix list.
	PrefixList *ManagedPrefixList `locationName:"prefixList" type:"structure"`
}

// String returns the string representation
func (s DeleteManagedPrefixListOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteManagedPrefixList = "DeleteManagedPrefixList"

// DeleteManagedPrefixListRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified managed prefix list. You must first remove all references
// to the prefix list in your resources.
//
//    // Example sending a request using DeleteManagedPrefixListRequest.
//    req := client.DeleteManagedPrefixListRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList
func (c *Client) DeleteManagedPrefixListRequest(input *DeleteManagedPrefixListInput) DeleteManagedPrefixListRequest {
	op := &aws.Operation{
		Name:       opDeleteManagedPrefixList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteManagedPrefixListInput{}
	}

	req := c.newRequest(op, input, &DeleteManagedPrefixListOutput{})

	return DeleteManagedPrefixListRequest{Request: req, Input: input, Copy: c.DeleteManagedPrefixListRequest}
}

// DeleteManagedPrefixListRequest is the request type for the
// DeleteManagedPrefixList API operation.
type DeleteManagedPrefixListRequest struct {
	*aws.Request
	Input *DeleteManagedPrefixListInput
	Copy  func(*DeleteManagedPrefixListInput) DeleteManagedPrefixListRequest
}

// Send marshals and sends the DeleteManagedPrefixList API request.
func (r DeleteManagedPrefixListRequest) Send(ctx context.Context) (*DeleteManagedPrefixListResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteManagedPrefixListResponse{
		DeleteManagedPrefixListOutput: r.Request.Data.(*DeleteManagedPrefixListOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteManagedPrefixListResponse is the response type for the
// DeleteManagedPrefixList API operation.
type DeleteManagedPrefixListResponse struct {
	*DeleteManagedPrefixListOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteManagedPrefixList request.
func (r *DeleteManagedPrefixListResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
