// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteNatGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the NAT gateway.
	//
	// NatGatewayId is a required field
	NatGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNatGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNatGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNatGatewayInput"}

	if s.NatGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NatGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`
}

// String returns the string representation
func (s DeleteNatGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNatGateway = "DeleteNatGateway"

// DeleteNatGatewayRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its
// Elastic IP address, but does not release the address from your account. Deleting
// a NAT gateway does not delete any NAT gateway routes in your route tables.
//
//    // Example sending a request using DeleteNatGatewayRequest.
//    req := client.DeleteNatGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *Client) DeleteNatGatewayRequest(input *DeleteNatGatewayInput) DeleteNatGatewayRequest {
	op := &aws.Operation{
		Name:       opDeleteNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNatGatewayInput{}
	}

	req := c.newRequest(op, input, &DeleteNatGatewayOutput{})

	return DeleteNatGatewayRequest{Request: req, Input: input, Copy: c.DeleteNatGatewayRequest}
}

// DeleteNatGatewayRequest is the request type for the
// DeleteNatGateway API operation.
type DeleteNatGatewayRequest struct {
	*aws.Request
	Input *DeleteNatGatewayInput
	Copy  func(*DeleteNatGatewayInput) DeleteNatGatewayRequest
}

// Send marshals and sends the DeleteNatGateway API request.
func (r DeleteNatGatewayRequest) Send(ctx context.Context) (*DeleteNatGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNatGatewayResponse{
		DeleteNatGatewayOutput: r.Request.Data.(*DeleteNatGatewayOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNatGatewayResponse is the response type for the
// DeleteNatGateway API operation.
type DeleteNatGatewayResponse struct {
	*DeleteNatGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNatGateway request.
func (r *DeleteNatGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
