// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type DeleteSubnetInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the subnet.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubnetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubnetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSubnetInput"}

	if s.SubnetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSubnetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubnetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSubnet = "DeleteSubnet"

// DeleteSubnetRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified subnet. You must terminate all running instances in
// the subnet before you can delete the subnet.
//
//    // Example sending a request using DeleteSubnetRequest.
//    req := client.DeleteSubnetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *Client) DeleteSubnetRequest(input *DeleteSubnetInput) DeleteSubnetRequest {
	op := &aws.Operation{
		Name:       opDeleteSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetInput{}
	}

	req := c.newRequest(op, input, &DeleteSubnetOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteSubnetRequest{Request: req, Input: input, Copy: c.DeleteSubnetRequest}
}

// DeleteSubnetRequest is the request type for the
// DeleteSubnet API operation.
type DeleteSubnetRequest struct {
	*aws.Request
	Input *DeleteSubnetInput
	Copy  func(*DeleteSubnetInput) DeleteSubnetRequest
}

// Send marshals and sends the DeleteSubnet API request.
func (r DeleteSubnetRequest) Send(ctx context.Context) (*DeleteSubnetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSubnetResponse{
		DeleteSubnetOutput: r.Request.Data.(*DeleteSubnetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSubnetResponse is the response type for the
// DeleteSubnet API operation.
type DeleteSubnetResponse struct {
	*DeleteSubnetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSubnet request.
func (r *DeleteSubnetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
