// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeExportImageTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of the export image tasks.
	ExportImageTaskIds []string `locationName:"ExportImageTaskId" locationNameList:"ExportImageTaskId" type:"list"`

	// Filter tasks using the task-state filter and one of the following values:
	// active, completed, deleting, or deleted.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeExportImageTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportImageTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExportImageTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeExportImageTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the export image tasks.
	ExportImageTasks []ExportImageTask `locationName:"exportImageTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportImageTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeExportImageTasks = "DescribeExportImageTasks"

// DescribeExportImageTasksRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the specified export image tasks or all of your export image tasks.
//
//    // Example sending a request using DescribeExportImageTasksRequest.
//    req := client.DescribeExportImageTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks
func (c *Client) DescribeExportImageTasksRequest(input *DescribeExportImageTasksInput) DescribeExportImageTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeExportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExportImageTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeExportImageTasksOutput{})

	return DescribeExportImageTasksRequest{Request: req, Input: input, Copy: c.DescribeExportImageTasksRequest}
}

// DescribeExportImageTasksRequest is the request type for the
// DescribeExportImageTasks API operation.
type DescribeExportImageTasksRequest struct {
	*aws.Request
	Input *DescribeExportImageTasksInput
	Copy  func(*DescribeExportImageTasksInput) DescribeExportImageTasksRequest
}

// Send marshals and sends the DescribeExportImageTasks API request.
func (r DescribeExportImageTasksRequest) Send(ctx context.Context) (*DescribeExportImageTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeExportImageTasksResponse{
		DescribeExportImageTasksOutput: r.Request.Data.(*DescribeExportImageTasksOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeExportImageTasksRequestPaginator returns a paginator for DescribeExportImageTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeExportImageTasksRequest(input)
//   p := ec2.NewDescribeExportImageTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeExportImageTasksPaginator(req DescribeExportImageTasksRequest) DescribeExportImageTasksPaginator {
	return DescribeExportImageTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeExportImageTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeExportImageTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeExportImageTasksPaginator struct {
	aws.Pager
}

func (p *DescribeExportImageTasksPaginator) CurrentPage() *DescribeExportImageTasksOutput {
	return p.Pager.CurrentPage().(*DescribeExportImageTasksOutput)
}

// DescribeExportImageTasksResponse is the response type for the
// DescribeExportImageTasks API operation.
type DescribeExportImageTasksResponse struct {
	*DescribeExportImageTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeExportImageTasks request.
func (r *DescribeExportImageTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
