// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInstanceEventNotificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeInstanceEventNotificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeInstanceEventNotificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the registered tag keys.
	InstanceTagAttribute *InstanceTagNotificationAttribute `locationName:"instanceTagAttribute" type:"structure"`
}

// String returns the string representation
func (s DescribeInstanceEventNotificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstanceEventNotificationAttributes = "DescribeInstanceEventNotificationAttributes"

// DescribeInstanceEventNotificationAttributesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the tag keys that are registered to appear in scheduled event notifications
// for resources in the current Region.
//
//    // Example sending a request using DescribeInstanceEventNotificationAttributesRequest.
//    req := client.DescribeInstanceEventNotificationAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes
func (c *Client) DescribeInstanceEventNotificationAttributesRequest(input *DescribeInstanceEventNotificationAttributesInput) DescribeInstanceEventNotificationAttributesRequest {
	op := &aws.Operation{
		Name:       opDescribeInstanceEventNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceEventNotificationAttributesInput{}
	}

	req := c.newRequest(op, input, &DescribeInstanceEventNotificationAttributesOutput{})

	return DescribeInstanceEventNotificationAttributesRequest{Request: req, Input: input, Copy: c.DescribeInstanceEventNotificationAttributesRequest}
}

// DescribeInstanceEventNotificationAttributesRequest is the request type for the
// DescribeInstanceEventNotificationAttributes API operation.
type DescribeInstanceEventNotificationAttributesRequest struct {
	*aws.Request
	Input *DescribeInstanceEventNotificationAttributesInput
	Copy  func(*DescribeInstanceEventNotificationAttributesInput) DescribeInstanceEventNotificationAttributesRequest
}

// Send marshals and sends the DescribeInstanceEventNotificationAttributes API request.
func (r DescribeInstanceEventNotificationAttributesRequest) Send(ctx context.Context) (*DescribeInstanceEventNotificationAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstanceEventNotificationAttributesResponse{
		DescribeInstanceEventNotificationAttributesOutput: r.Request.Data.(*DescribeInstanceEventNotificationAttributesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInstanceEventNotificationAttributesResponse is the response type for the
// DescribeInstanceEventNotificationAttributes API operation.
type DescribeInstanceEventNotificationAttributesResponse struct {
	*DescribeInstanceEventNotificationAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstanceEventNotificationAttributes request.
func (r *DescribeInstanceEventNotificationAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
