// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * local-gateway-id - The ID of a local gateway.
	//
	//    * local-gateway-route-table-id - The ID of the local gateway route table.
	//
	//    * local-gateway-route-table-virtual-interface-group-association-id - The
	//    ID of the association.
	//
	//    * local-gateway-route-table-virtual-interface-group-id - The ID of the
	//    virtual interface group.
	//
	//    * state - The state of the association.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The IDs of the associations.
	LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds []string `locationName:"LocalGatewayRouteTableVirtualInterfaceGroupAssociationId" locationNameList:"item" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	LocalGatewayRouteTableVirtualInterfaceGroupAssociations []LocalGatewayRouteTableVirtualInterfaceGroupAssociation `locationName:"localGatewayRouteTableVirtualInterfaceGroupAssociationSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the associations between virtual interface groups and local gateway
// route tables.
//
//    // Example sending a request using DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.
//    req := client.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
func (c *Client) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
	op := &aws.Operation{
		Name:       opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput{}
	}

	req := c.newRequest(op, input, &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput{})

	return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest{Request: req, Input: input, Copy: c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest}
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest is the request type for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API operation.
type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest struct {
	*aws.Request
	Input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput
	Copy  func(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
}

// Send marshals and sends the DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API request.
func (r DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) Send(ctx context.Context) (*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse{
		DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput: r.Request.Data.(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestPaginator returns a paginator for DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input)
//   p := ec2.NewDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator(req DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator {
	return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator struct {
	aws.Pager
}

func (p *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator) CurrentPage() *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput {
	return p.Pager.CurrentPage().(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse is the response type for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API operation.
type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse struct {
	*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations request.
func (r *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
