// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeMovingAddressesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * moving-status - The status of the Elastic IP address (MovingToVpc |
	//    RestoringToClassic).
	Filters []Filter `locationName:"filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1000; if MaxResults is given a value outside of this range, an error is returned.
	//
	// Default: If no value is provided, the default is 1000.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// One or more Elastic IP addresses.
	PublicIps []string `locationName:"publicIp" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeMovingAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMovingAddressesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMovingAddressesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeMovingAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The status for each Elastic IP address.
	MovingAddressStatuses []MovingAddressStatus `locationName:"movingAddressStatusSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeMovingAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMovingAddresses = "DescribeMovingAddresses"

// DescribeMovingAddressesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes your Elastic IP addresses that are being moved to the EC2-VPC platform,
// or that are being restored to the EC2-Classic platform. This request does
// not return information about any other Elastic IP addresses in your account.
//
//    // Example sending a request using DescribeMovingAddressesRequest.
//    req := client.DescribeMovingAddressesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses
func (c *Client) DescribeMovingAddressesRequest(input *DescribeMovingAddressesInput) DescribeMovingAddressesRequest {
	op := &aws.Operation{
		Name:       opDescribeMovingAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMovingAddressesInput{}
	}

	req := c.newRequest(op, input, &DescribeMovingAddressesOutput{})

	return DescribeMovingAddressesRequest{Request: req, Input: input, Copy: c.DescribeMovingAddressesRequest}
}

// DescribeMovingAddressesRequest is the request type for the
// DescribeMovingAddresses API operation.
type DescribeMovingAddressesRequest struct {
	*aws.Request
	Input *DescribeMovingAddressesInput
	Copy  func(*DescribeMovingAddressesInput) DescribeMovingAddressesRequest
}

// Send marshals and sends the DescribeMovingAddresses API request.
func (r DescribeMovingAddressesRequest) Send(ctx context.Context) (*DescribeMovingAddressesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMovingAddressesResponse{
		DescribeMovingAddressesOutput: r.Request.Data.(*DescribeMovingAddressesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeMovingAddressesRequestPaginator returns a paginator for DescribeMovingAddresses.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeMovingAddressesRequest(input)
//   p := ec2.NewDescribeMovingAddressesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeMovingAddressesPaginator(req DescribeMovingAddressesRequest) DescribeMovingAddressesPaginator {
	return DescribeMovingAddressesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeMovingAddressesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeMovingAddressesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeMovingAddressesPaginator struct {
	aws.Pager
}

func (p *DescribeMovingAddressesPaginator) CurrentPage() *DescribeMovingAddressesOutput {
	return p.Pager.CurrentPage().(*DescribeMovingAddressesOutput)
}

// DescribeMovingAddressesResponse is the response type for the
// DescribeMovingAddresses API operation.
type DescribeMovingAddressesResponse struct {
	*DescribeMovingAddressesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMovingAddresses request.
func (r *DescribeMovingAddressesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
