// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTransitGatewayMulticastDomainsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. The possible values are:
	//
	//    * state - The state of the transit gateway multicast domain. Valid values
	//    are pending | available | deleting | deleted.
	//
	//    * transit-gateway-id - The ID of the transit gateway.
	//
	//    * transit-gateway-multicast-domain-id - The ID of the transit gateway
	//    multicast domain.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainIds []string `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayMulticastDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransitGatewayMulticastDomainsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTransitGatewayMulticastDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTransitGatewayMulticastDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the transit gateway multicast domains.
	TransitGatewayMulticastDomains []TransitGatewayMulticastDomain `locationName:"transitGatewayMulticastDomains" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayMulticastDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTransitGatewayMulticastDomains = "DescribeTransitGatewayMulticastDomains"

// DescribeTransitGatewayMulticastDomainsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more transit gateway multicast domains.
//
//    // Example sending a request using DescribeTransitGatewayMulticastDomainsRequest.
//    req := client.DescribeTransitGatewayMulticastDomainsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayMulticastDomains
func (c *Client) DescribeTransitGatewayMulticastDomainsRequest(input *DescribeTransitGatewayMulticastDomainsInput) DescribeTransitGatewayMulticastDomainsRequest {
	op := &aws.Operation{
		Name:       opDescribeTransitGatewayMulticastDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTransitGatewayMulticastDomainsInput{}
	}

	req := c.newRequest(op, input, &DescribeTransitGatewayMulticastDomainsOutput{})

	return DescribeTransitGatewayMulticastDomainsRequest{Request: req, Input: input, Copy: c.DescribeTransitGatewayMulticastDomainsRequest}
}

// DescribeTransitGatewayMulticastDomainsRequest is the request type for the
// DescribeTransitGatewayMulticastDomains API operation.
type DescribeTransitGatewayMulticastDomainsRequest struct {
	*aws.Request
	Input *DescribeTransitGatewayMulticastDomainsInput
	Copy  func(*DescribeTransitGatewayMulticastDomainsInput) DescribeTransitGatewayMulticastDomainsRequest
}

// Send marshals and sends the DescribeTransitGatewayMulticastDomains API request.
func (r DescribeTransitGatewayMulticastDomainsRequest) Send(ctx context.Context) (*DescribeTransitGatewayMulticastDomainsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTransitGatewayMulticastDomainsResponse{
		DescribeTransitGatewayMulticastDomainsOutput: r.Request.Data.(*DescribeTransitGatewayMulticastDomainsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTransitGatewayMulticastDomainsRequestPaginator returns a paginator for DescribeTransitGatewayMulticastDomains.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTransitGatewayMulticastDomainsRequest(input)
//   p := ec2.NewDescribeTransitGatewayMulticastDomainsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTransitGatewayMulticastDomainsPaginator(req DescribeTransitGatewayMulticastDomainsRequest) DescribeTransitGatewayMulticastDomainsPaginator {
	return DescribeTransitGatewayMulticastDomainsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTransitGatewayMulticastDomainsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTransitGatewayMulticastDomainsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTransitGatewayMulticastDomainsPaginator struct {
	aws.Pager
}

func (p *DescribeTransitGatewayMulticastDomainsPaginator) CurrentPage() *DescribeTransitGatewayMulticastDomainsOutput {
	return p.Pager.CurrentPage().(*DescribeTransitGatewayMulticastDomainsOutput)
}

// DescribeTransitGatewayMulticastDomainsResponse is the response type for the
// DescribeTransitGatewayMulticastDomains API operation.
type DescribeTransitGatewayMulticastDomainsResponse struct {
	*DescribeTransitGatewayMulticastDomainsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTransitGatewayMulticastDomains request.
func (r *DescribeTransitGatewayMulticastDomainsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
