// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisableVpcClassicLinkInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableVpcClassicLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableVpcClassicLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableVpcClassicLinkInput"}

	if s.VpcId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableVpcClassicLinkOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DisableVpcClassicLinkOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableVpcClassicLink = "DisableVpcClassicLink"

// DisableVpcClassicLinkRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
// that has EC2-Classic instances linked to it.
//
//    // Example sending a request using DisableVpcClassicLinkRequest.
//    req := client.DisableVpcClassicLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLink
func (c *Client) DisableVpcClassicLinkRequest(input *DisableVpcClassicLinkInput) DisableVpcClassicLinkRequest {
	op := &aws.Operation{
		Name:       opDisableVpcClassicLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVpcClassicLinkInput{}
	}

	req := c.newRequest(op, input, &DisableVpcClassicLinkOutput{})

	return DisableVpcClassicLinkRequest{Request: req, Input: input, Copy: c.DisableVpcClassicLinkRequest}
}

// DisableVpcClassicLinkRequest is the request type for the
// DisableVpcClassicLink API operation.
type DisableVpcClassicLinkRequest struct {
	*aws.Request
	Input *DisableVpcClassicLinkInput
	Copy  func(*DisableVpcClassicLinkInput) DisableVpcClassicLinkRequest
}

// Send marshals and sends the DisableVpcClassicLink API request.
func (r DisableVpcClassicLinkRequest) Send(ctx context.Context) (*DisableVpcClassicLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableVpcClassicLinkResponse{
		DisableVpcClassicLinkOutput: r.Request.Data.(*DisableVpcClassicLinkOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableVpcClassicLinkResponse is the response type for the
// DisableVpcClassicLink API operation.
type DisableVpcClassicLinkResponse struct {
	*DisableVpcClassicLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableVpcClassicLink request.
func (r *DisableVpcClassicLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
