// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCoipPoolUsageInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The filters. The following are the possible values:
	//
	//    * coip-address-usage.allocation-id
	//
	//    * coip-address-usage.aws-account-id
	//
	//    * coip-address-usage.aws-service
	//
	//    * coip-address-usage.co-ip
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the address pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetCoipPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoipPoolUsageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCoipPoolUsageInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if s.PoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCoipPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the address usage.
	CoipAddressUsages []CoipAddressUsage `locationName:"coipAddressUsageSet" locationNameList:"item" type:"list"`

	// The ID of the customer-owned address pool.
	CoipPoolId *string `locationName:"coipPoolId" type:"string"`

	// The ID of the local gateway route table.
	LocalGatewayRouteTableId *string `locationName:"localGatewayRouteTableId" type:"string"`
}

// String returns the string representation
func (s GetCoipPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCoipPoolUsage = "GetCoipPoolUsage"

// GetCoipPoolUsageRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the allocations from the specified customer-owned address pool.
//
//    // Example sending a request using GetCoipPoolUsageRequest.
//    req := client.GetCoipPoolUsageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetCoipPoolUsage
func (c *Client) GetCoipPoolUsageRequest(input *GetCoipPoolUsageInput) GetCoipPoolUsageRequest {
	op := &aws.Operation{
		Name:       opGetCoipPoolUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCoipPoolUsageInput{}
	}

	req := c.newRequest(op, input, &GetCoipPoolUsageOutput{})

	return GetCoipPoolUsageRequest{Request: req, Input: input, Copy: c.GetCoipPoolUsageRequest}
}

// GetCoipPoolUsageRequest is the request type for the
// GetCoipPoolUsage API operation.
type GetCoipPoolUsageRequest struct {
	*aws.Request
	Input *GetCoipPoolUsageInput
	Copy  func(*GetCoipPoolUsageInput) GetCoipPoolUsageRequest
}

// Send marshals and sends the GetCoipPoolUsage API request.
func (r GetCoipPoolUsageRequest) Send(ctx context.Context) (*GetCoipPoolUsageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCoipPoolUsageResponse{
		GetCoipPoolUsageOutput: r.Request.Data.(*GetCoipPoolUsageOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCoipPoolUsageResponse is the response type for the
// GetCoipPoolUsage API operation.
type GetCoipPoolUsageResponse struct {
	*GetCoipPoolUsageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCoipPoolUsage request.
func (r *GetCoipPoolUsageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
