// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyAvailabilityZoneGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The name of the Availability Zone Group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// Indicates whether to enable or disable membership. The valid values are opted-in.
	// You must contact AWS Support (https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services)
	// to disable an Availability Zone group.
	//
	// OptInStatus is a required field
	OptInStatus ModifyAvailabilityZoneOptInStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ModifyAvailabilityZoneGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyAvailabilityZoneGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyAvailabilityZoneGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if len(s.OptInStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OptInStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyAvailabilityZoneGroupOutput struct {
	_ struct{} `type:"structure"`

	// Is true if the request succeeds, and an error otherwise.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifyAvailabilityZoneGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyAvailabilityZoneGroup = "ModifyAvailabilityZoneGroup"

// ModifyAvailabilityZoneGroupRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Enables or disables an Availability Zone group for your account.
//
// Use DescribeAvailabilityZones (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html)
// to view the value for GroupName.
//
//    // Example sending a request using ModifyAvailabilityZoneGroupRequest.
//    req := client.ModifyAvailabilityZoneGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyAvailabilityZoneGroup
func (c *Client) ModifyAvailabilityZoneGroupRequest(input *ModifyAvailabilityZoneGroupInput) ModifyAvailabilityZoneGroupRequest {
	op := &aws.Operation{
		Name:       opModifyAvailabilityZoneGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAvailabilityZoneGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyAvailabilityZoneGroupOutput{})

	return ModifyAvailabilityZoneGroupRequest{Request: req, Input: input, Copy: c.ModifyAvailabilityZoneGroupRequest}
}

// ModifyAvailabilityZoneGroupRequest is the request type for the
// ModifyAvailabilityZoneGroup API operation.
type ModifyAvailabilityZoneGroupRequest struct {
	*aws.Request
	Input *ModifyAvailabilityZoneGroupInput
	Copy  func(*ModifyAvailabilityZoneGroupInput) ModifyAvailabilityZoneGroupRequest
}

// Send marshals and sends the ModifyAvailabilityZoneGroup API request.
func (r ModifyAvailabilityZoneGroupRequest) Send(ctx context.Context) (*ModifyAvailabilityZoneGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyAvailabilityZoneGroupResponse{
		ModifyAvailabilityZoneGroupOutput: r.Request.Data.(*ModifyAvailabilityZoneGroupOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyAvailabilityZoneGroupResponse is the response type for the
// ModifyAvailabilityZoneGroup API operation.
type ModifyAvailabilityZoneGroupResponse struct {
	*ModifyAvailabilityZoneGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyAvailabilityZoneGroup request.
func (r *ModifyAvailabilityZoneGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
