// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for ModifyImageAttribute.
type ModifyImageAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to modify. The valid values are description, launchPermission,
	// and productCodes.
	Attribute *string `type:"string"`

	// A new description for the AMI.
	Description *AttributeValue `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the AMI.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// A new launch permission for the AMI.
	LaunchPermission *LaunchPermissionModifications `type:"structure"`

	// The operation type. This parameter can be used only when the Attribute parameter
	// is launchPermission.
	OperationType OperationType `type:"string" enum:"true"`

	// The DevPay product codes. After you add a product code to an AMI, it can't
	// be removed.
	ProductCodes []string `locationName:"ProductCode" locationNameList:"ProductCode" type:"list"`

	// The user groups. This parameter can be used only when the Attribute parameter
	// is launchPermission.
	UserGroups []string `locationName:"UserGroup" locationNameList:"UserGroup" type:"list"`

	// The AWS account IDs. This parameter can be used only when the Attribute parameter
	// is launchPermission.
	UserIds []string `locationName:"UserId" locationNameList:"UserId" type:"list"`

	// The value of the attribute being modified. This parameter can be used only
	// when the Attribute parameter is description or productCodes.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ModifyImageAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyImageAttributeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyImageAttributeInput"}

	if s.ImageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyImageAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyImageAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyImageAttribute = "ModifyImageAttribute"

// ModifyImageAttributeRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the specified attribute of the specified AMI. You can specify only
// one attribute at a time. You can use the Attribute parameter to specify the
// attribute or one of the following parameters: Description, LaunchPermission,
// or ProductCode.
//
// AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace
// product code cannot be made public.
//
// To enable the SriovNetSupport enhanced networking attribute of an image,
// enable SriovNetSupport on an instance and create an AMI from the instance.
//
//    // Example sending a request using ModifyImageAttributeRequest.
//    req := client.ModifyImageAttributeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyImageAttribute
func (c *Client) ModifyImageAttributeRequest(input *ModifyImageAttributeInput) ModifyImageAttributeRequest {
	op := &aws.Operation{
		Name:       opModifyImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyImageAttributeInput{}
	}

	req := c.newRequest(op, input, &ModifyImageAttributeOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return ModifyImageAttributeRequest{Request: req, Input: input, Copy: c.ModifyImageAttributeRequest}
}

// ModifyImageAttributeRequest is the request type for the
// ModifyImageAttribute API operation.
type ModifyImageAttributeRequest struct {
	*aws.Request
	Input *ModifyImageAttributeInput
	Copy  func(*ModifyImageAttributeInput) ModifyImageAttributeRequest
}

// Send marshals and sends the ModifyImageAttribute API request.
func (r ModifyImageAttributeRequest) Send(ctx context.Context) (*ModifyImageAttributeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyImageAttributeResponse{
		ModifyImageAttributeOutput: r.Request.Data.(*ModifyImageAttributeOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyImageAttributeResponse is the response type for the
// ModifyImageAttribute API operation.
type ModifyImageAttributeResponse struct {
	*ModifyImageAttributeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyImageAttribute request.
func (r *ModifyImageAttributeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
