// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterTransitGatewayMulticastGroupSourcesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IP address assigned to the transit gateway multicast group.
	GroupIpAddress *string `type:"string"`

	// The group sources' network interface IDs to register with the transit gateway
	// multicast group.
	NetworkInterfaceIds []string `locationNameList:"item" type:"list"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s RegisterTransitGatewayMulticastGroupSourcesInput) String() string {
	return awsutil.Prettify(s)
}

type RegisterTransitGatewayMulticastGroupSourcesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the transit gateway multicast group sources.
	RegisteredMulticastGroupSources *TransitGatewayMulticastRegisteredGroupSources `locationName:"registeredMulticastGroupSources" type:"structure"`
}

// String returns the string representation
func (s RegisterTransitGatewayMulticastGroupSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterTransitGatewayMulticastGroupSources = "RegisterTransitGatewayMulticastGroupSources"

// RegisterTransitGatewayMulticastGroupSourcesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Registers sources (network interfaces) with the specified transit gateway
// multicast group.
//
// A multicast source is a network interface attached to a supported instance
// that sends multicast traffic. For information about supported instances,
// see Multicast Considerations (https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits)
// in Amazon VPC Transit Gateways.
//
// After you add the source, use SearchTransitGatewayMulticastGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html)
// to verify that the source was added to the multicast group.
//
//    // Example sending a request using RegisterTransitGatewayMulticastGroupSourcesRequest.
//    req := client.RegisterTransitGatewayMulticastGroupSourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RegisterTransitGatewayMulticastGroupSources
func (c *Client) RegisterTransitGatewayMulticastGroupSourcesRequest(input *RegisterTransitGatewayMulticastGroupSourcesInput) RegisterTransitGatewayMulticastGroupSourcesRequest {
	op := &aws.Operation{
		Name:       opRegisterTransitGatewayMulticastGroupSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTransitGatewayMulticastGroupSourcesInput{}
	}

	req := c.newRequest(op, input, &RegisterTransitGatewayMulticastGroupSourcesOutput{})

	return RegisterTransitGatewayMulticastGroupSourcesRequest{Request: req, Input: input, Copy: c.RegisterTransitGatewayMulticastGroupSourcesRequest}
}

// RegisterTransitGatewayMulticastGroupSourcesRequest is the request type for the
// RegisterTransitGatewayMulticastGroupSources API operation.
type RegisterTransitGatewayMulticastGroupSourcesRequest struct {
	*aws.Request
	Input *RegisterTransitGatewayMulticastGroupSourcesInput
	Copy  func(*RegisterTransitGatewayMulticastGroupSourcesInput) RegisterTransitGatewayMulticastGroupSourcesRequest
}

// Send marshals and sends the RegisterTransitGatewayMulticastGroupSources API request.
func (r RegisterTransitGatewayMulticastGroupSourcesRequest) Send(ctx context.Context) (*RegisterTransitGatewayMulticastGroupSourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTransitGatewayMulticastGroupSourcesResponse{
		RegisterTransitGatewayMulticastGroupSourcesOutput: r.Request.Data.(*RegisterTransitGatewayMulticastGroupSourcesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTransitGatewayMulticastGroupSourcesResponse is the response type for the
// RegisterTransitGatewayMulticastGroupSources API operation.
type RegisterTransitGatewayMulticastGroupSourcesResponse struct {
	*RegisterTransitGatewayMulticastGroupSourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterTransitGatewayMulticastGroupSources request.
func (r *RegisterTransitGatewayMulticastGroupSourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
