// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type ReplaceNetworkAclEntryInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 network range to allow or deny, in CIDR notation (for example 172.16.0.0/24).
	CidrBlock *string `locationName:"cidrBlock" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Indicates whether to replace the egress rule.
	//
	// Default: If no value is specified, we replace the ingress rule.
	//
	// Egress is a required field
	Egress *bool `locationName:"egress" type:"boolean" required:"true"`

	// ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
	// 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
	IcmpTypeCode *IcmpTypeCode `locationName:"Icmp" type:"structure"`

	// The IPv6 network range to allow or deny, in CIDR notation (for example 2001:bd8:1234:1a00::/64).
	Ipv6CidrBlock *string `locationName:"ipv6CidrBlock" type:"string"`

	// The ID of the ACL.
	//
	// NetworkAclId is a required field
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`

	// TCP or UDP protocols: The range of ports the rule applies to. Required if
	// specifying protocol 6 (TCP) or 17 (UDP).
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol number. A value of "-1" means all protocols. If you specify
	// "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP),
	// traffic on all ports is allowed, regardless of any ports or ICMP types or
	// codes that you specify. If you specify protocol "58" (ICMPv6) and specify
	// an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless
	// of any that you specify. If you specify protocol "58" (ICMPv6) and specify
	// an IPv6 CIDR block, you must specify an ICMP type and code.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	//
	// RuleAction is a required field
	RuleAction RuleAction `locationName:"ruleAction" type:"string" required:"true" enum:"true"`

	// The rule number of the entry to replace.
	//
	// RuleNumber is a required field
	RuleNumber *int64 `locationName:"ruleNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s ReplaceNetworkAclEntryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceNetworkAclEntryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplaceNetworkAclEntryInput"}

	if s.Egress == nil {
		invalidParams.Add(aws.NewErrParamRequired("Egress"))
	}

	if s.NetworkAclId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkAclId"))
	}

	if s.Protocol == nil {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}
	if len(s.RuleAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RuleAction"))
	}

	if s.RuleNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ReplaceNetworkAclEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceNetworkAclEntryOutput) String() string {
	return awsutil.Prettify(s)
}

const opReplaceNetworkAclEntry = "ReplaceNetworkAclEntry"

// ReplaceNetworkAclEntryRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Replaces an entry (rule) in a network ACL. For more information, see Network
// ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html) in
// the Amazon Virtual Private Cloud User Guide.
//
//    // Example sending a request using ReplaceNetworkAclEntryRequest.
//    req := client.ReplaceNetworkAclEntryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclEntry
func (c *Client) ReplaceNetworkAclEntryRequest(input *ReplaceNetworkAclEntryInput) ReplaceNetworkAclEntryRequest {
	op := &aws.Operation{
		Name:       opReplaceNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclEntryInput{}
	}

	req := c.newRequest(op, input, &ReplaceNetworkAclEntryOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return ReplaceNetworkAclEntryRequest{Request: req, Input: input, Copy: c.ReplaceNetworkAclEntryRequest}
}

// ReplaceNetworkAclEntryRequest is the request type for the
// ReplaceNetworkAclEntry API operation.
type ReplaceNetworkAclEntryRequest struct {
	*aws.Request
	Input *ReplaceNetworkAclEntryInput
	Copy  func(*ReplaceNetworkAclEntryInput) ReplaceNetworkAclEntryRequest
}

// Send marshals and sends the ReplaceNetworkAclEntry API request.
func (r ReplaceNetworkAclEntryRequest) Send(ctx context.Context) (*ReplaceNetworkAclEntryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReplaceNetworkAclEntryResponse{
		ReplaceNetworkAclEntryOutput: r.Request.Data.(*ReplaceNetworkAclEntryOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReplaceNetworkAclEntryResponse is the response type for the
// ReplaceNetworkAclEntry API operation.
type ReplaceNetworkAclEntryResponse struct {
	*ReplaceNetworkAclEntryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReplaceNetworkAclEntry request.
func (r *ReplaceNetworkAclEntryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
