// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeImageScanFindingsInput struct {
	_ struct{} `type:"structure"`

	// An object with identifying information for an Amazon ECR image.
	//
	// ImageId is a required field
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure" required:"true"`

	// The maximum number of image scan results returned by DescribeImageScanFindings
	// in paginated output. When this parameter is used, DescribeImageScanFindings
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeImageScanFindings request with the returned nextToken value.
	// This value can be between 1 and 1000. If this parameter is not used, then
	// DescribeImageScanFindings returns up to 100 results and a nextToken value,
	// if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeImageScanFindings
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// in which to describe the image scan findings for. If you do not specify a
	// registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository for the image for which to describe the scan findings.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeImageScanFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageScanFindingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeImageScanFindingsInput"}

	if s.ImageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.ImageId != nil {
		if err := s.ImageId.Validate(); err != nil {
			invalidParams.AddNested("ImageId", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeImageScanFindingsOutput struct {
	_ struct{} `type:"structure"`

	// An object with identifying information for an Amazon ECR image.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`

	// The information contained in the image scan findings.
	ImageScanFindings *ImageScanFindings `locationName:"imageScanFindings" type:"structure"`

	// The current state of the scan.
	ImageScanStatus *ImageScanStatus `locationName:"imageScanStatus" type:"structure"`

	// The nextToken value to include in a future DescribeImageScanFindings request.
	// When the results of a DescribeImageScanFindings request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeImageScanFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeImageScanFindings = "DescribeImageScanFindings"

// DescribeImageScanFindingsRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Returns the scan findings for the specified image.
//
//    // Example sending a request using DescribeImageScanFindingsRequest.
//    req := client.DescribeImageScanFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings
func (c *Client) DescribeImageScanFindingsRequest(input *DescribeImageScanFindingsInput) DescribeImageScanFindingsRequest {
	op := &aws.Operation{
		Name:       opDescribeImageScanFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImageScanFindingsInput{}
	}

	req := c.newRequest(op, input, &DescribeImageScanFindingsOutput{})

	return DescribeImageScanFindingsRequest{Request: req, Input: input, Copy: c.DescribeImageScanFindingsRequest}
}

// DescribeImageScanFindingsRequest is the request type for the
// DescribeImageScanFindings API operation.
type DescribeImageScanFindingsRequest struct {
	*aws.Request
	Input *DescribeImageScanFindingsInput
	Copy  func(*DescribeImageScanFindingsInput) DescribeImageScanFindingsRequest
}

// Send marshals and sends the DescribeImageScanFindings API request.
func (r DescribeImageScanFindingsRequest) Send(ctx context.Context) (*DescribeImageScanFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeImageScanFindingsResponse{
		DescribeImageScanFindingsOutput: r.Request.Data.(*DescribeImageScanFindingsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeImageScanFindingsRequestPaginator returns a paginator for DescribeImageScanFindings.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeImageScanFindingsRequest(input)
//   p := ecr.NewDescribeImageScanFindingsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeImageScanFindingsPaginator(req DescribeImageScanFindingsRequest) DescribeImageScanFindingsPaginator {
	return DescribeImageScanFindingsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeImageScanFindingsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeImageScanFindingsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeImageScanFindingsPaginator struct {
	aws.Pager
}

func (p *DescribeImageScanFindingsPaginator) CurrentPage() *DescribeImageScanFindingsOutput {
	return p.Pager.CurrentPage().(*DescribeImageScanFindingsOutput)
}

// DescribeImageScanFindingsResponse is the response type for the
// DescribeImageScanFindings API operation.
type DescribeImageScanFindingsResponse struct {
	*DescribeImageScanFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeImageScanFindings request.
func (r *DescribeImageScanFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
