// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// If the policy you are attempting to set on a repository policy would prevent
	// you from setting another policy in the future, you must force the SetRepositoryPolicy
	// operation. This is intended to prevent accidental repository lock outs.
	Force *bool `locationName:"force" type:"boolean"`

	// The JSON repository policy text to apply to the repository. For more information,
	// see Amazon ECR Repository Policies (https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html)
	// in the Amazon Elastic Container Registry User Guide.
	//
	// PolicyText is a required field
	PolicyText *string `locationName:"policyText" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to receive the policy.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s SetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRepositoryPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetRepositoryPolicyInput"}

	if s.PolicyText == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyText"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text applied to the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s SetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetRepositoryPolicy = "SetRepositoryPolicy"

// SetRepositoryPolicyRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Applies a repository policy to the specified repository to control access
// permissions. For more information, see Amazon ECR Repository Policies (https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html)
// in the Amazon Elastic Container Registry User Guide.
//
//    // Example sending a request using SetRepositoryPolicyRequest.
//    req := client.SetRepositoryPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy
func (c *Client) SetRepositoryPolicyRequest(input *SetRepositoryPolicyInput) SetRepositoryPolicyRequest {
	op := &aws.Operation{
		Name:       opSetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRepositoryPolicyInput{}
	}

	req := c.newRequest(op, input, &SetRepositoryPolicyOutput{})

	return SetRepositoryPolicyRequest{Request: req, Input: input, Copy: c.SetRepositoryPolicyRequest}
}

// SetRepositoryPolicyRequest is the request type for the
// SetRepositoryPolicy API operation.
type SetRepositoryPolicyRequest struct {
	*aws.Request
	Input *SetRepositoryPolicyInput
	Copy  func(*SetRepositoryPolicyInput) SetRepositoryPolicyRequest
}

// Send marshals and sends the SetRepositoryPolicy API request.
func (r SetRepositoryPolicyRequest) Send(ctx context.Context) (*SetRepositoryPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetRepositoryPolicyResponse{
		SetRepositoryPolicyOutput: r.Request.Data.(*SetRepositoryPolicyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetRepositoryPolicyResponse is the response type for the
// SetRepositoryPolicy API operation.
type SetRepositoryPolicyResponse struct {
	*SetRepositoryPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetRepositoryPolicy request.
func (r *SetRepositoryPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
