// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to return the effective settings. If true, the account
	// settings for the root user or the default setting for the principalArn are
	// returned. If false, the account settings for the principalArn are returned
	// if they are set. Otherwise, no account settings are returned.
	EffectiveSettings *bool `locationName:"effectiveSettings" type:"boolean"`

	// The maximum number of account setting results returned by ListAccountSettings
	// in paginated output. When this parameter is used, ListAccountSettings only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListAccountSettings request with the returned nextToken value. This
	// value can be between 1 and 10. If this parameter is not used, then ListAccountSettings
	// returns up to 10 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The name of the account setting you want to list the settings for.
	Name SettingName `locationName:"name" type:"string" enum:"true"`

	// The nextToken value returned from a ListAccountSettings request indicating
	// that more results are available to fulfill the request and further calls
	// will be needed. If maxResults was provided, it is possible the number of
	// results to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If this field is omitted, the account settings are listed only for
	// the authenticated user.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// The value of the account settings with which to filter results. You must
	// also specify an account setting name to use this parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ListAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

type ListAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListAccountSettings request. When
	// the results of a ListAccountSettings request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The account settings for the resource.
	Settings []Setting `locationName:"settings" type:"list"`
}

// String returns the string representation
func (s ListAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAccountSettings = "ListAccountSettings"

// ListAccountSettingsRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Lists the account settings for a specified principal.
//
//    // Example sending a request using ListAccountSettingsRequest.
//    req := client.ListAccountSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings
func (c *Client) ListAccountSettingsRequest(input *ListAccountSettingsInput) ListAccountSettingsRequest {
	op := &aws.Operation{
		Name:       opListAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountSettingsInput{}
	}

	req := c.newRequest(op, input, &ListAccountSettingsOutput{})

	return ListAccountSettingsRequest{Request: req, Input: input, Copy: c.ListAccountSettingsRequest}
}

// ListAccountSettingsRequest is the request type for the
// ListAccountSettings API operation.
type ListAccountSettingsRequest struct {
	*aws.Request
	Input *ListAccountSettingsInput
	Copy  func(*ListAccountSettingsInput) ListAccountSettingsRequest
}

// Send marshals and sends the ListAccountSettings API request.
func (r ListAccountSettingsRequest) Send(ctx context.Context) (*ListAccountSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccountSettingsResponse{
		ListAccountSettingsOutput: r.Request.Data.(*ListAccountSettingsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAccountSettingsRequestPaginator returns a paginator for ListAccountSettings.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAccountSettingsRequest(input)
//   p := ecs.NewListAccountSettingsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAccountSettingsPaginator(req ListAccountSettingsRequest) ListAccountSettingsPaginator {
	return ListAccountSettingsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAccountSettingsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAccountSettingsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAccountSettingsPaginator struct {
	aws.Pager
}

func (p *ListAccountSettingsPaginator) CurrentPage() *ListAccountSettingsOutput {
	return p.Pager.CurrentPage().(*ListAccountSettingsOutput)
}

// ListAccountSettingsResponse is the response type for the
// ListAccountSettings API operation.
type ListAccountSettingsResponse struct {
	*ListAccountSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccountSettings request.
func (r *ListAccountSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
