// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTasksInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the tasks to list. If you do not specify a cluster, the default cluster is
	// assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN of the container instance with which
	// to filter the ListTasks results. Specifying a containerInstance limits the
	// results to tasks that belong to that container instance.
	ContainerInstance *string `locationName:"containerInstance" type:"string"`

	// The task desired status with which to filter the ListTasks results. Specifying
	// a desiredStatus of STOPPED limits the results to tasks that Amazon ECS has
	// set the desired status to STOPPED. This can be useful for debugging tasks
	// that are not starting properly or have died or finished. The default status
	// filter is RUNNING, which shows tasks that Amazon ECS has set the desired
	// status to RUNNING.
	//
	// Although you can filter results based on a desired status of PENDING, this
	// does not return any results. Amazon ECS never sets the desired status of
	// a task to that value (only a task's lastStatus may have a value of PENDING).
	DesiredStatus DesiredStatus `locationName:"desiredStatus" type:"string" enum:"true"`

	// The name of the family with which to filter the ListTasks results. Specifying
	// a family limits the results to tasks that belong to that family.
	Family *string `locationName:"family" type:"string"`

	// The launch type for services to list.
	LaunchType LaunchType `locationName:"launchType" type:"string" enum:"true"`

	// The maximum number of task results returned by ListTasks in paginated output.
	// When this parameter is used, ListTasks only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListTasks request with
	// the returned nextToken value. This value can be between 1 and 100. If this
	// parameter is not used, then ListTasks returns up to 100 results and a nextToken
	// value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListTasks request indicating that more
	// results are available to fulfill the request and further calls will be needed.
	// If maxResults was provided, it is possible the number of results to be fewer
	// than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service with which to filter the ListTasks results. Specifying
	// a serviceName limits the results to tasks that belong to that service.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The startedBy value with which to filter the task results. Specifying a startedBy
	// value limits the results to tasks that were started with that value.
	StartedBy *string `locationName:"startedBy" type:"string"`
}

// String returns the string representation
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListTasks request. When the results
	// of a ListTasks request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of task ARN entries for the ListTasks request.
	TaskArns []string `locationName:"taskArns" type:"list"`
}

// String returns the string representation
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTasks = "ListTasks"

// ListTasksRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Returns a list of tasks for a specified cluster. You can filter the results
// by family name, by a particular container instance, or by the desired status
// of the task with the family, containerInstance, and desiredStatus parameters.
//
// Recently stopped tasks might appear in the returned results. Currently, stopped
// tasks appear in the returned results for at least one hour.
//
//    // Example sending a request using ListTasksRequest.
//    req := client.ListTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks
func (c *Client) ListTasksRequest(input *ListTasksInput) ListTasksRequest {
	op := &aws.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	req := c.newRequest(op, input, &ListTasksOutput{})

	return ListTasksRequest{Request: req, Input: input, Copy: c.ListTasksRequest}
}

// ListTasksRequest is the request type for the
// ListTasks API operation.
type ListTasksRequest struct {
	*aws.Request
	Input *ListTasksInput
	Copy  func(*ListTasksInput) ListTasksRequest
}

// Send marshals and sends the ListTasks API request.
func (r ListTasksRequest) Send(ctx context.Context) (*ListTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTasksResponse{
		ListTasksOutput: r.Request.Data.(*ListTasksOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTasksRequestPaginator returns a paginator for ListTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTasksRequest(input)
//   p := ecs.NewListTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTasksPaginator(req ListTasksRequest) ListTasksPaginator {
	return ListTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTasksPaginator struct {
	aws.Pager
}

func (p *ListTasksPaginator) CurrentPage() *ListTasksOutput {
	return p.Pager.CurrentPage().(*ListTasksOutput)
}

// ListTasksResponse is the response type for the
// ListTasks API operation.
type ListTasksResponse struct {
	*ListTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTasks request.
func (r *ListTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
