// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutAccountSettingDefaultInput struct {
	_ struct{} `type:"structure"`

	// The resource name for which to modify the account setting. If serviceLongArnFormat
	// is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat
	// is specified, the ARN and resource ID for your Amazon ECS tasks is affected.
	// If containerInstanceLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS container instances is affected. If awsvpcTrunking is specified,
	// the ENI limit for your Amazon ECS container instances is affected. If containerInsights
	// is specified, the default setting for CloudWatch Container Insights for your
	// clusters is affected.
	//
	// Name is a required field
	Name SettingName `locationName:"name" type:"string" required:"true" enum:"true"`

	// The account setting value for the specified principal ARN. Accepted values
	// are enabled and disabled.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s PutAccountSettingDefaultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountSettingDefaultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAccountSettingDefaultInput"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutAccountSettingDefaultOutput struct {
	_ struct{} `type:"structure"`

	// The current account setting for a resource.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation
func (s PutAccountSettingDefaultOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAccountSettingDefault = "PutAccountSettingDefault"

// PutAccountSettingDefaultRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Modifies an account setting for all IAM users on an account for whom no individual
// account setting has been specified. Account settings are set on a per-Region
// basis.
//
//    // Example sending a request using PutAccountSettingDefaultRequest.
//    req := client.PutAccountSettingDefaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingDefault
func (c *Client) PutAccountSettingDefaultRequest(input *PutAccountSettingDefaultInput) PutAccountSettingDefaultRequest {
	op := &aws.Operation{
		Name:       opPutAccountSettingDefault,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAccountSettingDefaultInput{}
	}

	req := c.newRequest(op, input, &PutAccountSettingDefaultOutput{})

	return PutAccountSettingDefaultRequest{Request: req, Input: input, Copy: c.PutAccountSettingDefaultRequest}
}

// PutAccountSettingDefaultRequest is the request type for the
// PutAccountSettingDefault API operation.
type PutAccountSettingDefaultRequest struct {
	*aws.Request
	Input *PutAccountSettingDefaultInput
	Copy  func(*PutAccountSettingDefaultInput) PutAccountSettingDefaultRequest
}

// Send marshals and sends the PutAccountSettingDefault API request.
func (r PutAccountSettingDefaultRequest) Send(ctx context.Context) (*PutAccountSettingDefaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAccountSettingDefaultResponse{
		PutAccountSettingDefaultOutput: r.Request.Data.(*PutAccountSettingDefaultOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAccountSettingDefaultResponse is the response type for the
// PutAccountSettingDefault API operation.
type PutAccountSettingDefaultResponse struct {
	*PutAccountSettingDefaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAccountSettingDefault request.
func (r *PutAccountSettingDefaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
