// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopTaskInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the task to stop. If you do not specify a cluster, the default cluster is
	// assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// An optional message specified when a task is stopped. For example, if you
	// are using a custom scheduler, you can use this parameter to specify the reason
	// for stopping the task here, and the message appears in subsequent DescribeTasks
	// API operations on this task. Up to 255 characters are allowed in this message.
	Reason *string `locationName:"reason" type:"string"`

	// The task ID or full Amazon Resource Name (ARN) of the task to stop.
	//
	// Task is a required field
	Task *string `locationName:"task" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopTaskInput"}

	if s.Task == nil {
		invalidParams.Add(aws.NewErrParamRequired("Task"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task that was stopped.
	Task *Task `locationName:"task" type:"structure"`
}

// String returns the string representation
func (s StopTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopTask = "StopTask"

// StopTaskRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Stops a running task. Any tags associated with the task will be deleted.
//
// When StopTask is called on a task, the equivalent of docker stop is issued
// to the containers running in the task. This results in a SIGTERM value and
// a default 30-second timeout, after which the SIGKILL value is sent and the
// containers are forcibly stopped. If the container handles the SIGTERM value
// gracefully and exits within 30 seconds from receiving it, no SIGKILL value
// is sent.
//
// The default 30-second timeout can be configured on the Amazon ECS container
// agent with the ECS_CONTAINER_STOP_TIMEOUT variable. For more information,
// see Amazon ECS Container Agent Configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using StopTaskRequest.
//    req := client.StopTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopTask
func (c *Client) StopTaskRequest(input *StopTaskInput) StopTaskRequest {
	op := &aws.Operation{
		Name:       opStopTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTaskInput{}
	}

	req := c.newRequest(op, input, &StopTaskOutput{})

	return StopTaskRequest{Request: req, Input: input, Copy: c.StopTaskRequest}
}

// StopTaskRequest is the request type for the
// StopTask API operation.
type StopTaskRequest struct {
	*aws.Request
	Input *StopTaskInput
	Copy  func(*StopTaskInput) StopTaskRequest
}

// Send marshals and sends the StopTask API request.
func (r StopTaskRequest) Send(ctx context.Context) (*StopTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopTaskResponse{
		StopTaskOutput: r.Request.Data.(*StopTaskOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopTaskResponse is the response type for the
// StopTask API operation.
type StopTaskResponse struct {
	*StopTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopTask request.
func (r *StopTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
