// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteAccessPointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access point that you want to delete.
	//
	// AccessPointId is a required field
	AccessPointId *string `location:"uri" locationName:"AccessPointId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAccessPointInput"}

	if s.AccessPointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAccessPointInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessPointId != nil {
		v := *s.AccessPointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AccessPointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAccessPointOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteAccessPoint = "DeleteAccessPoint"

// DeleteAccessPointRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Deletes the specified access point. After deletion is complete, new clients
// can no longer connect to the access points. Clients connected to the access
// point at the time of deletion will continue to function until they terminate
// their connection.
//
// This operation requires permissions for the elasticfilesystem:DeleteAccessPoint
// action.
//
//    // Example sending a request using DeleteAccessPointRequest.
//    req := client.DeleteAccessPointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteAccessPoint
func (c *Client) DeleteAccessPointRequest(input *DeleteAccessPointInput) DeleteAccessPointRequest {
	op := &aws.Operation{
		Name:       opDeleteAccessPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/access-points/{AccessPointId}",
	}

	if input == nil {
		input = &DeleteAccessPointInput{}
	}

	req := c.newRequest(op, input, &DeleteAccessPointOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteAccessPointRequest{Request: req, Input: input, Copy: c.DeleteAccessPointRequest}
}

// DeleteAccessPointRequest is the request type for the
// DeleteAccessPoint API operation.
type DeleteAccessPointRequest struct {
	*aws.Request
	Input *DeleteAccessPointInput
	Copy  func(*DeleteAccessPointInput) DeleteAccessPointRequest
}

// Send marshals and sends the DeleteAccessPoint API request.
func (r DeleteAccessPointRequest) Send(ctx context.Context) (*DeleteAccessPointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAccessPointResponse{
		DeleteAccessPointOutput: r.Request.Data.(*DeleteAccessPointOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAccessPointResponse is the response type for the
// DeleteAccessPoint API operation.
type DeleteAccessPointResponse struct {
	*DeleteAccessPointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAccessPoint request.
func (r *DeleteAccessPointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
