// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAccessPointsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies an EFS access point to describe in the response; mutually
	// exclusive with FileSystemId.
	AccessPointId *string `location:"querystring" locationName:"AccessPointId" type:"string"`

	// (Optional) If you provide a FileSystemId, EFS returns all access points for
	// that file system; mutually exclusive with AccessPointId.
	FileSystemId *string `location:"querystring" locationName:"FileSystemId" type:"string"`

	// (Optional) When retrieving all access points for a file system, you can optionally
	// specify the MaxItems parameter to limit the number of objects returned in
	// a response. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// NextToken is present if the response is paginated. You can use NextMarker
	// in the subsequent request to fetch the next page of access point descriptions.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessPointsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAccessPointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAccessPointsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessPointId != nil {
		v := *s.AccessPointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "AccessPointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// An array of access point descriptions.
	AccessPoints []AccessPointDescription `type:"list"`

	// Present if there are more access points than returned in the response. You
	// can use the NextMarker in the subsequent request to fetch the additional
	// descriptions.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAccessPointsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPoints != nil {
		v := s.AccessPoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AccessPoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeAccessPoints = "DescribeAccessPoints"

// DescribeAccessPointsRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Returns the description of a specific Amazon EFS access point if the AccessPointId
// is provided. If you provide an EFS FileSystemId, it returns descriptions
// of all access points for that file system. You can provide either an AccessPointId
// or a FileSystemId in the request, but not both.
//
// This operation requires permissions for the elasticfilesystem:DescribeAccessPoints
// action.
//
//    // Example sending a request using DescribeAccessPointsRequest.
//    req := client.DescribeAccessPointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints
func (c *Client) DescribeAccessPointsRequest(input *DescribeAccessPointsInput) DescribeAccessPointsRequest {
	op := &aws.Operation{
		Name:       opDescribeAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/access-points",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAccessPointsInput{}
	}

	req := c.newRequest(op, input, &DescribeAccessPointsOutput{})

	return DescribeAccessPointsRequest{Request: req, Input: input, Copy: c.DescribeAccessPointsRequest}
}

// DescribeAccessPointsRequest is the request type for the
// DescribeAccessPoints API operation.
type DescribeAccessPointsRequest struct {
	*aws.Request
	Input *DescribeAccessPointsInput
	Copy  func(*DescribeAccessPointsInput) DescribeAccessPointsRequest
}

// Send marshals and sends the DescribeAccessPoints API request.
func (r DescribeAccessPointsRequest) Send(ctx context.Context) (*DescribeAccessPointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAccessPointsResponse{
		DescribeAccessPointsOutput: r.Request.Data.(*DescribeAccessPointsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAccessPointsRequestPaginator returns a paginator for DescribeAccessPoints.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAccessPointsRequest(input)
//   p := efs.NewDescribeAccessPointsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAccessPointsPaginator(req DescribeAccessPointsRequest) DescribeAccessPointsPaginator {
	return DescribeAccessPointsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAccessPointsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAccessPointsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAccessPointsPaginator struct {
	aws.Pager
}

func (p *DescribeAccessPointsPaginator) CurrentPage() *DescribeAccessPointsOutput {
	return p.Pager.CurrentPage().(*DescribeAccessPointsOutput)
}

// DescribeAccessPointsResponse is the response type for the
// DescribeAccessPoints API operation.
type DescribeAccessPointsResponse struct {
	*DescribeAccessPointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAccessPoints request.
func (r *DescribeAccessPointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
