// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeBackupPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies which EFS file system to retrieve the BackupPolicy for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBackupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBackupPolicyInput"}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeBackupPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeBackupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Describes the file system's backup policy, indicating whether automatic backups
	// are turned on or off..
	BackupPolicy *BackupPolicy `type:"structure"`
}

// String returns the string representation
func (s DescribeBackupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeBackupPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPolicy != nil {
		v := s.BackupPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BackupPolicy", v, metadata)
	}
	return nil
}

const opDescribeBackupPolicy = "DescribeBackupPolicy"

// DescribeBackupPolicyRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Returns the backup policy for the specified EFS file system.
//
//    // Example sending a request using DescribeBackupPolicyRequest.
//    req := client.DescribeBackupPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeBackupPolicy
func (c *Client) DescribeBackupPolicyRequest(input *DescribeBackupPolicyInput) DescribeBackupPolicyRequest {
	op := &aws.Operation{
		Name:       opDescribeBackupPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
	}

	if input == nil {
		input = &DescribeBackupPolicyInput{}
	}

	req := c.newRequest(op, input, &DescribeBackupPolicyOutput{})

	return DescribeBackupPolicyRequest{Request: req, Input: input, Copy: c.DescribeBackupPolicyRequest}
}

// DescribeBackupPolicyRequest is the request type for the
// DescribeBackupPolicy API operation.
type DescribeBackupPolicyRequest struct {
	*aws.Request
	Input *DescribeBackupPolicyInput
	Copy  func(*DescribeBackupPolicyInput) DescribeBackupPolicyRequest
}

// Send marshals and sends the DescribeBackupPolicy API request.
func (r DescribeBackupPolicyRequest) Send(ctx context.Context) (*DescribeBackupPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBackupPolicyResponse{
		DescribeBackupPolicyOutput: r.Request.Data.(*DescribeBackupPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBackupPolicyResponse is the response type for the
// DescribeBackupPolicy API operation.
type DescribeBackupPolicyResponse struct {
	*DescribeBackupPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBackupPolicy request.
func (r *DescribeBackupPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
