// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutFileSystemPolicyInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A flag to indicate whether to bypass the FileSystemPolicy lockout
	// safety check. The policy lockout safety check determines whether the policy
	// in the request will prevent the principal making the request will be locked
	// out from making future PutFileSystemPolicy requests on the file system. Set
	// BypassPolicyLockoutSafetyCheck to True only when you intend to prevent the
	// principal that is making the request from making a subsequent PutFileSystemPolicy
	// request on the file system. The default value is False.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// The ID of the EFS file system that you want to create or update the FileSystemPolicy
	// for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// The FileSystemPolicy that you're creating. Accepts a JSON formatted policy
	// definition. To find out more about the elements that make up a file system
	// policy, see EFS Resource-based Policies (https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies).
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutFileSystemPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFileSystemPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutFileSystemPolicyInput"}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFileSystemPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BypassPolicyLockoutSafetyCheck != nil {
		v := *s.BypassPolicyLockoutSafetyCheck

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BypassPolicyLockoutSafetyCheck", protocol.BoolValue(v), metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutFileSystemPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the EFS file system to which the FileSystemPolicy applies.
	FileSystemId *string `type:"string"`

	// The JSON formatted FileSystemPolicy for the EFS file system.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s PutFileSystemPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFileSystemPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutFileSystemPolicy = "PutFileSystemPolicy"

// PutFileSystemPolicyRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Applies an Amazon EFS FileSystemPolicy to an Amazon EFS file system. A file
// system policy is an IAM resource-based policy and can contain multiple policy
// statements. A file system always has exactly one file system policy, which
// can be the default policy or an explicit policy set or updated using this
// API operation. When an explicit policy is set, it overrides the default policy.
// For more information about the default file system policy, see Default EFS
// File System Policy (https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy).
//
// This operation requires permissions for the elasticfilesystem:PutFileSystemPolicy
// action.
//
//    // Example sending a request using PutFileSystemPolicyRequest.
//    req := client.PutFileSystemPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutFileSystemPolicy
func (c *Client) PutFileSystemPolicyRequest(input *PutFileSystemPolicyInput) PutFileSystemPolicyRequest {
	op := &aws.Operation{
		Name:       opPutFileSystemPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/policy",
	}

	if input == nil {
		input = &PutFileSystemPolicyInput{}
	}

	req := c.newRequest(op, input, &PutFileSystemPolicyOutput{})

	return PutFileSystemPolicyRequest{Request: req, Input: input, Copy: c.PutFileSystemPolicyRequest}
}

// PutFileSystemPolicyRequest is the request type for the
// PutFileSystemPolicy API operation.
type PutFileSystemPolicyRequest struct {
	*aws.Request
	Input *PutFileSystemPolicyInput
	Copy  func(*PutFileSystemPolicyInput) PutFileSystemPolicyRequest
}

// Send marshals and sends the PutFileSystemPolicy API request.
func (r PutFileSystemPolicyRequest) Send(ctx context.Context) (*PutFileSystemPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutFileSystemPolicyResponse{
		PutFileSystemPolicyOutput: r.Request.Data.(*PutFileSystemPolicyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutFileSystemPolicyResponse is the response type for the
// PutFileSystemPolicy API operation.
type PutFileSystemPolicyResponse struct {
	*PutFileSystemPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutFileSystemPolicy request.
func (r *PutFileSystemPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
