// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Provides a description of an EFS file system access point.
type AccessPointDescription struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) associated with the access point.
	AccessPointArn *string `type:"string"`

	// The ID of the access point, assigned by Amazon EFS.
	AccessPointId *string `type:"string"`

	// The opaque string specified in the request to ensure idempotent creation.
	ClientToken *string `min:"1" type:"string"`

	// The ID of the EFS file system that the access point applies to.
	FileSystemId *string `type:"string"`

	// Identifies the lifecycle phase of the access point.
	LifeCycleState LifeCycleState `type:"string" enum:"true"`

	// The name of the access point. This is the value of the Name tag.
	Name *string `type:"string"`

	// Identified the AWS account that owns the access point resource.
	OwnerId *string `type:"string"`

	// The full POSIX identity, including the user ID, group ID, and secondary group
	// IDs on the access point that is used for all file operations by NFS clients
	// using the access point.
	PosixUser *PosixUser `type:"structure"`

	// The directory on the Amazon EFS file system that the access point exposes
	// as the root directory to NFS clients using the access point.
	RootDirectory *RootDirectory `type:"structure"`

	// The tags associated with the access point, presented as an array of Tag objects.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s AccessPointDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessPointDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPointArn != nil {
		v := *s.AccessPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessPointId != nil {
		v := *s.AccessPointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessPointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LifeCycleState) > 0 {
		v := s.LifeCycleState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LifeCycleState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PosixUser != nil {
		v := s.PosixUser

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PosixUser", v, metadata)
	}
	if s.RootDirectory != nil {
		v := s.RootDirectory

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RootDirectory", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The backup policy for the file system, showing the curent status. If ENABLED,
// the file system is being backed up.
type BackupPolicy struct {
	_ struct{} `type:"structure"`

	// Describes the status of the file system's backup policy.
	//
	//    * ENABLED - EFS is automatically backing up the file system.
	//
	//    * ENABLING - EFS is turning on automatic backups for the file system.
	//
	//    * DISABLED - automatic back ups are turned off for the file system.
	//
	//    * DISABLED - EFS is turning off automatic backups for the file system.
	//
	// Status is a required field
	Status Status `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s BackupPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BackupPolicy"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Required if the RootDirectory > Path specified does not exist. Specifies
// the POSIX IDs and permissions to apply to the access point's RootDirectory
// > Path. If the access point root directory does not exist, EFS creates it
// with these settings when a client connects to the access point. When specifying
// CreationInfo, you must include values for all properties.
//
// If you do not provide CreationInfo and the specified RootDirectory does not
// exist, attempts to mount the file system using the access point will fail.
type CreationInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the POSIX group ID to apply to the RootDirectory. Accepts values
	// from 0 to 2^32 (4294967295).
	//
	// OwnerGid is a required field
	OwnerGid *int64 `type:"long" required:"true"`

	// Specifies the POSIX user ID to apply to the RootDirectory. Accepts values
	// from 0 to 2^32 (4294967295).
	//
	// OwnerUid is a required field
	OwnerUid *int64 `type:"long" required:"true"`

	// Specifies the POSIX permissions to apply to the RootDirectory, in the format
	// of an octal number representing the file's mode bits.
	//
	// Permissions is a required field
	Permissions *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreationInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreationInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreationInfo"}

	if s.OwnerGid == nil {
		invalidParams.Add(aws.NewErrParamRequired("OwnerGid"))
	}

	if s.OwnerUid == nil {
		invalidParams.Add(aws.NewErrParamRequired("OwnerUid"))
	}

	if s.Permissions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Permissions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreationInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.OwnerGid != nil {
		v := *s.OwnerGid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerGid", protocol.Int64Value(v), metadata)
	}
	if s.OwnerUid != nil {
		v := *s.OwnerUid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerUid", protocol.Int64Value(v), metadata)
	}
	if s.Permissions != nil {
		v := *s.Permissions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permissions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A description of the file system.
type FileSystemDescription struct {
	_ struct{} `type:"structure"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The opaque string specified in the request.
	//
	// CreationToken is a required field
	CreationToken *string `min:"1" type:"string" required:"true"`

	// A Boolean value that, if true, indicates that the file system is encrypted.
	Encrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the EFS file system, in the format arn:aws:elasticfilesystem:region:account-id:file-system/file-system-id
	// . Example with sample data: arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567
	FileSystemArn *string `type:"string"`

	// The ID of the file system, assigned by Amazon EFS.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The ID of an AWS Key Management Service (AWS KMS) customer master key (CMK)
	// that was used to protect the encrypted file system.
	KmsKeyId *string `type:"string"`

	// The lifecycle phase of the file system.
	//
	// LifeCycleState is a required field
	LifeCycleState LifeCycleState `type:"string" required:"true" enum:"true"`

	// You can add tags to a file system, including a Name tag. For more information,
	// see CreateFileSystem. If the file system has a Name tag, Amazon EFS returns
	// the value in this field.
	Name *string `type:"string"`

	// The current number of mount targets that the file system has. For more information,
	// see CreateMountTarget.
	//
	// NumberOfMountTargets is a required field
	NumberOfMountTargets *int64 `type:"integer" required:"true"`

	// The AWS account that created the file system. If the file system was created
	// by an IAM user, the parent account to which the user belongs is the owner.
	//
	// OwnerId is a required field
	OwnerId *string `type:"string" required:"true"`

	// The performance mode of the file system.
	//
	// PerformanceMode is a required field
	PerformanceMode PerformanceMode `type:"string" required:"true" enum:"true"`

	// The throughput, measured in MiB/s, that you want to provision for a file
	// system. Valid values are 1-1024. Required if ThroughputMode is set to provisioned.
	// The limit on throughput is 1024 MiB/s. You can get these limits increased
	// by contacting AWS Support. For more information, see Amazon EFS Limits That
	// You Can Increase (https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits)
	// in the Amazon EFS User Guide.
	ProvisionedThroughputInMibps *float64 `min:"1" type:"double"`

	// The latest known metered size (in bytes) of data stored in the file system,
	// in its Value field, and the time at which that size was determined in its
	// Timestamp field. The Timestamp value is the integer number of seconds since
	// 1970-01-01T00:00:00Z. The SizeInBytes value doesn't represent the size of
	// a consistent snapshot of the file system, but it is eventually consistent
	// when there are no writes to the file system. That is, SizeInBytes represents
	// actual size only if the file system is not modified for a period longer than
	// a couple of hours. Otherwise, the value is not the exact size that the file
	// system was at any point in time.
	//
	// SizeInBytes is a required field
	SizeInBytes *FileSystemSize `type:"structure" required:"true"`

	// The tags associated with the file system, presented as an array of Tag objects.
	//
	// Tags is a required field
	Tags []Tag `type:"list" required:"true"`

	// The throughput mode for a file system. There are two throughput modes to
	// choose from for your file system: bursting and provisioned. If you set ThroughputMode
	// to provisioned, you must also set a value for ProvisionedThroughPutInMibps.
	// You can decrease your file system's throughput in Provisioned Throughput
	// mode or change between the throughput modes as long as it’s been more than
	// 24 hours since the last decrease or throughput mode change.
	ThroughputMode ThroughputMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s FileSystemDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FileSystemDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreationToken != nil {
		v := *s.CreationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encrypted != nil {
		v := *s.Encrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Encrypted", protocol.BoolValue(v), metadata)
	}
	if s.FileSystemArn != nil {
		v := *s.FileSystemArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileSystemArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LifeCycleState) > 0 {
		v := s.LifeCycleState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LifeCycleState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NumberOfMountTargets != nil {
		v := *s.NumberOfMountTargets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberOfMountTargets", protocol.Int64Value(v), metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PerformanceMode) > 0 {
		v := s.PerformanceMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PerformanceMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProvisionedThroughputInMibps != nil {
		v := *s.ProvisionedThroughputInMibps

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProvisionedThroughputInMibps", protocol.Float64Value(v), metadata)
	}
	if s.SizeInBytes != nil {
		v := s.SizeInBytes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SizeInBytes", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThroughputMode) > 0 {
		v := s.ThroughputMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThroughputMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The latest known metered size (in bytes) of data stored in the file system,
// in its Value field, and the time at which that size was determined in its
// Timestamp field. The value doesn't represent the size of a consistent snapshot
// of the file system, but it is eventually consistent when there are no writes
// to the file system. That is, the value represents the actual size only if
// the file system is not modified for a period longer than a couple of hours.
// Otherwise, the value is not necessarily the exact size the file system was
// at any instant in time.
type FileSystemSize struct {
	_ struct{} `type:"structure"`

	// The time at which the size of data, returned in the Value field, was determined.
	// The value is the integer number of seconds since 1970-01-01T00:00:00Z.
	Timestamp *time.Time `type:"timestamp"`

	// The latest known metered size (in bytes) of data stored in the file system.
	//
	// Value is a required field
	Value *int64 `type:"long" required:"true"`

	// The latest known metered size (in bytes) of data stored in the Infrequent
	// Access storage class.
	ValueInIA *int64 `type:"long"`

	// The latest known metered size (in bytes) of data stored in the Standard storage
	// class.
	ValueInStandard *int64 `type:"long"`
}

// String returns the string representation
func (s FileSystemSize) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FileSystemSize) MarshalFields(e protocol.FieldEncoder) error {
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	if s.ValueInIA != nil {
		v := *s.ValueInIA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ValueInIA", protocol.Int64Value(v), metadata)
	}
	if s.ValueInStandard != nil {
		v := *s.ValueInStandard

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ValueInStandard", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes a policy used by EFS lifecycle management to transition files to
// the Infrequent Access (IA) storage class.
type LifecyclePolicy struct {
	_ struct{} `type:"structure"`

	// A value that describes the period of time that a file is not accessed, after
	// which it transitions to the IA storage class. Metadata operations such as
	// listing the contents of a directory don't count as file access events.
	TransitionToIA TransitionToIARules `type:"string" enum:"true"`
}

// String returns the string representation
func (s LifecyclePolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecyclePolicy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.TransitionToIA) > 0 {
		v := s.TransitionToIA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TransitionToIA", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides a description of a mount target.
type MountTargetDescription struct {
	_ struct{} `type:"structure"`

	// The unique and consistent identifier of the Availability Zone (AZ) that the
	// mount target resides in. For example, use1-az1 is an AZ ID for the us-east-1
	// Region and it has the same location in every AWS account.
	AvailabilityZoneId *string `type:"string"`

	// The name of the Availability Zone (AZ) that the mount target resides in.
	// AZs are independently mapped to names for each AWS account. For example,
	// the Availability Zone us-east-1a for your AWS account might not be the same
	// location as us-east-1a for another AWS account.
	AvailabilityZoneName *string `type:"string"`

	// The ID of the file system for which the mount target is intended.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// Address at which the file system can be mounted by using the mount target.
	IpAddress *string `min:"7" type:"string"`

	// Lifecycle state of the mount target.
	//
	// LifeCycleState is a required field
	LifeCycleState LifeCycleState `type:"string" required:"true" enum:"true"`

	// System-assigned mount target ID.
	//
	// MountTargetId is a required field
	MountTargetId *string `min:"13" type:"string" required:"true"`

	// The ID of the network interface that Amazon EFS created when it created the
	// mount target.
	NetworkInterfaceId *string `type:"string"`

	// AWS account ID that owns the resource.
	OwnerId *string `type:"string"`

	// The ID of the mount target's subnet.
	//
	// SubnetId is a required field
	SubnetId *string `min:"15" type:"string" required:"true"`

	// The Virtual Private Cloud (VPC) ID that the mount target is configured in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s MountTargetDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MountTargetDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZoneId != nil {
		v := *s.AvailabilityZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AvailabilityZoneName != nil {
		v := *s.AvailabilityZoneName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZoneName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpAddress != nil {
		v := *s.IpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LifeCycleState) > 0 {
		v := s.LifeCycleState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LifeCycleState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MountTargetId != nil {
		v := *s.MountTargetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MountTargetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The full POSIX identity, including the user ID, group ID, and any secondary
// group IDs, on the access point that is used for all file system operations
// performed by NFS clients using the access point.
type PosixUser struct {
	_ struct{} `type:"structure"`

	// The POSIX group ID used for all file system operations using this access
	// point.
	//
	// Gid is a required field
	Gid *int64 `type:"long" required:"true"`

	// Secondary POSIX group IDs used for all file system operations using this
	// access point.
	SecondaryGids []int64 `type:"list"`

	// The POSIX user ID used for all file system operations using this access point.
	//
	// Uid is a required field
	Uid *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s PosixUser) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PosixUser) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PosixUser"}

	if s.Gid == nil {
		invalidParams.Add(aws.NewErrParamRequired("Gid"))
	}

	if s.Uid == nil {
		invalidParams.Add(aws.NewErrParamRequired("Uid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PosixUser) MarshalFields(e protocol.FieldEncoder) error {
	if s.Gid != nil {
		v := *s.Gid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Gid", protocol.Int64Value(v), metadata)
	}
	if s.SecondaryGids != nil {
		v := s.SecondaryGids

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecondaryGids", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Int64Value(v1))
		}
		ls0.End()

	}
	if s.Uid != nil {
		v := *s.Uid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Uid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the directory on the Amazon EFS file system that the access point
// provides access to. The access point exposes the specified file system path
// as the root directory of your file system to applications using the access
// point. NFS clients using the access point can only access data in the access
// point's RootDirectory and it's subdirectories.
type RootDirectory struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies the POSIX IDs and permissions to apply to the access
	// point's RootDirectory. If the RootDirectory > Path specified does not exist,
	// EFS creates the root directory using the CreationInfo settings when a client
	// connects to an access point. When specifying the CreationInfo, you must provide
	// values for all properties.
	//
	// If you do not provide CreationInfo and the specified RootDirectory > Path
	// does not exist, attempts to mount the file system using the access point
	// will fail.
	CreationInfo *CreationInfo `type:"structure"`

	// Specifies the path on the EFS file system to expose as the root directory
	// to NFS clients using the access point to access the EFS file system. A path
	// can have up to four subdirectories. If the specified path does not exist,
	// you are required to provide the CreationInfo.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RootDirectory) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RootDirectory) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RootDirectory"}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}
	if s.CreationInfo != nil {
		if err := s.CreationInfo.Validate(); err != nil {
			invalidParams.AddNested("CreationInfo", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RootDirectory) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationInfo != nil {
		v := s.CreationInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreationInfo", v, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A tag is a key-value pair. Allowed characters are letters, white space, and
// numbers that can be represented in UTF-8, and the following characters:+
// - = . _ : /
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key (String). The key can't start with aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
