// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package efsiface provides an interface to enable mocking the Amazon Elastic File System service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package efsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/efs"
)

// ClientAPI provides an interface to enable mocking the
// efs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // EFS.
//    func myFunc(svc efsiface.ClientAPI) bool {
//        // Make svc.CreateAccessPoint request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := efs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        efsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateAccessPoint(input *efs.CreateAccessPointInput) (*efs.CreateAccessPointOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateAccessPointRequest(*efs.CreateAccessPointInput) efs.CreateAccessPointRequest

	CreateFileSystemRequest(*efs.CreateFileSystemInput) efs.CreateFileSystemRequest

	CreateMountTargetRequest(*efs.CreateMountTargetInput) efs.CreateMountTargetRequest

	CreateTagsRequest(*efs.CreateTagsInput) efs.CreateTagsRequest

	DeleteAccessPointRequest(*efs.DeleteAccessPointInput) efs.DeleteAccessPointRequest

	DeleteFileSystemRequest(*efs.DeleteFileSystemInput) efs.DeleteFileSystemRequest

	DeleteFileSystemPolicyRequest(*efs.DeleteFileSystemPolicyInput) efs.DeleteFileSystemPolicyRequest

	DeleteMountTargetRequest(*efs.DeleteMountTargetInput) efs.DeleteMountTargetRequest

	DeleteTagsRequest(*efs.DeleteTagsInput) efs.DeleteTagsRequest

	DescribeAccessPointsRequest(*efs.DescribeAccessPointsInput) efs.DescribeAccessPointsRequest

	DescribeBackupPolicyRequest(*efs.DescribeBackupPolicyInput) efs.DescribeBackupPolicyRequest

	DescribeFileSystemPolicyRequest(*efs.DescribeFileSystemPolicyInput) efs.DescribeFileSystemPolicyRequest

	DescribeFileSystemsRequest(*efs.DescribeFileSystemsInput) efs.DescribeFileSystemsRequest

	DescribeLifecycleConfigurationRequest(*efs.DescribeLifecycleConfigurationInput) efs.DescribeLifecycleConfigurationRequest

	DescribeMountTargetSecurityGroupsRequest(*efs.DescribeMountTargetSecurityGroupsInput) efs.DescribeMountTargetSecurityGroupsRequest

	DescribeMountTargetsRequest(*efs.DescribeMountTargetsInput) efs.DescribeMountTargetsRequest

	DescribeTagsRequest(*efs.DescribeTagsInput) efs.DescribeTagsRequest

	ListTagsForResourceRequest(*efs.ListTagsForResourceInput) efs.ListTagsForResourceRequest

	ModifyMountTargetSecurityGroupsRequest(*efs.ModifyMountTargetSecurityGroupsInput) efs.ModifyMountTargetSecurityGroupsRequest

	PutBackupPolicyRequest(*efs.PutBackupPolicyInput) efs.PutBackupPolicyRequest

	PutFileSystemPolicyRequest(*efs.PutFileSystemPolicyInput) efs.PutFileSystemPolicyRequest

	PutLifecycleConfigurationRequest(*efs.PutLifecycleConfigurationInput) efs.PutLifecycleConfigurationRequest

	TagResourceRequest(*efs.TagResourceInput) efs.TagResourceRequest

	UntagResourceRequest(*efs.UntagResourceInput) efs.UntagResourceRequest

	UpdateFileSystemRequest(*efs.UpdateFileSystemInput) efs.UpdateFileSystemRequest
}

var _ ClientAPI = (*efs.Client)(nil)
