// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to describe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClusterInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeClusterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your specified cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeClusterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cluster != nil {
		v := s.Cluster

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cluster", v, metadata)
	}
	return nil
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Amazon EKS cluster.
//
// The API server endpoint and certificate authority data returned by this operation
// are required for kubelet and kubectl to communicate with your Kubernetes
// API server. For more information, see Create a kubeconfig for Amazon EKS
// (https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
//
// The API server endpoint and certificate authority data aren't available until
// the cluster reaches the ACTIVE state.
//
//    // Example sending a request using DescribeClusterRequest.
//    req := client.DescribeClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *Client) DescribeClusterRequest(input *DescribeClusterInput) DescribeClusterRequest {
	op := &aws.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterOutput{})

	return DescribeClusterRequest{Request: req, Input: input, Copy: c.DescribeClusterRequest}
}

// DescribeClusterRequest is the request type for the
// DescribeCluster API operation.
type DescribeClusterRequest struct {
	*aws.Request
	Input *DescribeClusterInput
	Copy  func(*DescribeClusterInput) DescribeClusterRequest
}

// Send marshals and sends the DescribeCluster API request.
func (r DescribeClusterRequest) Send(ctx context.Context) (*DescribeClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterResponse{
		DescribeClusterOutput: r.Request.Data.(*DescribeClusterOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeClusterResponse is the response type for the
// DescribeCluster API operation.
type DescribeClusterResponse struct {
	*DescribeClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCluster request.
func (r *DescribeClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
