// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An Auto Scaling group that is associated with an Amazon EKS managed node
// group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with an Amazon EKS managed
	// node group.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AutoScalingGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file
	// for your cluster.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Certificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Data != nil {
		v := *s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "data", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing an Amazon EKS cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string `locationName:"arn" type:"string"`

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate `locationName:"certificateAuthority" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The Unix epoch timestamp in seconds for when the cluster was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The encryption configuration for the cluster.
	EncryptionConfig []EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The endpoint for your Kubernetes API server.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The identity provider information for the cluster.
	Identity *Identity `locationName:"identity" type:"structure"`

	// The logging configuration for your cluster.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the cluster.
	Name *string `locationName:"name" type:"string"`

	// The platform version of your Amazon EKS cluster. For more information, see
	// Platform Versions (https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html)
	// in the Amazon EKS User Guide .
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide.
	ResourcesVpcConfig *VpcConfigResponse `locationName:"resourcesVpcConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to AWS API operations on your
	// behalf.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the cluster.
	Status ClusterStatus `locationName:"status" type:"string" enum:"true"`

	// The metadata that you apply to the cluster to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Cluster tags do not propagate to any other resources
	// associated with the cluster.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes server version for the cluster.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Cluster) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateAuthority != nil {
		v := s.CertificateAuthority

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "certificateAuthority", v, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EncryptionConfig != nil {
		v := s.EncryptionConfig

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "encryptionConfig", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := s.Identity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "identity", v, metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logging", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlatformVersion != nil {
		v := *s.PlatformVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platformVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourcesVpcConfig != nil {
		v := s.ResourcesVpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourcesVpcConfig", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// AWS Key Management Service (AWS KMS) customer master key (CMK). Either the
	// ARN or the alias can be used.
	Provider *Provider `locationName:"provider" type:"structure"`

	// Specifies the resources to be encrypted. The only supported value is "secrets".
	Resources []string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Provider != nil {
		v := s.Provider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "provider", v, metadata)
	}
	if s.Resources != nil {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * SubnetNotFound: We couldn't find one of the subnets associated with
	//    the cluster.
	//
	//    * SecurityGroupNotFound: We couldn't find one of the security groups associated
	//    with the cluster.
	//
	//    * EniLimitReached: You have reached the elastic network interface limit
	//    for your account.
	//
	//    * IpNotAvailable: A subnet associated with the cluster doesn't have any
	//    free IP addresses.
	//
	//    * AccessDenied: You don't have permissions to perform the specified operation.
	//
	//    * OperationNotPermitted: The service role associated with the cluster
	//    doesn't have the required access permissions for Amazon EKS.
	//
	//    * VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode ErrorCode `locationName:"errorCode" type:"string" enum:"true"`

	// A more complete description of the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDetail) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceIds != nil {
		v := s.ResourceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing an AWS Fargate profile.
type FargateProfile struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that the Fargate profile belongs to.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the Fargate profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string `locationName:"fargateProfileArn" type:"string"`

	// The name of the Fargate profile.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The Amazon Resource Name (ARN) of the pod execution role to use for pods
	// that match the selectors in the Fargate profile. For more information, see
	// Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string"`

	// The selectors to match for pods to use this Fargate profile.
	Selectors []FargateProfileSelector `locationName:"selectors" type:"list"`

	// The current status of the Fargate profile.
	Status FargateProfileStatus `locationName:"status" type:"string" enum:"true"`

	// The IDs of subnets to launch pods into.
	Subnets []string `locationName:"subnets" type:"list"`

	// The metadata applied to the Fargate profile to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Fargate profile tags do not propagate to any other resources
	// associated with the Fargate profile, such as the pods that are scheduled
	// with it.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s FargateProfile) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FargateProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clusterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.FargateProfileArn != nil {
		v := *s.FargateProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fargateProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FargateProfileName != nil {
		v := *s.FargateProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fargateProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PodExecutionRoleArn != nil {
		v := *s.PodExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "podExecutionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Selectors != nil {
		v := s.Selectors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "selectors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// An object representing an AWS Fargate profile selector.
type FargateProfileSelector struct {
	_ struct{} `type:"structure"`

	// The Kubernetes labels that the selector should match. A pod must contain
	// all of the labels that are specified in the selector for it to be considered
	// a match.
	Labels map[string]string `locationName:"labels" type:"map"`

	// The Kubernetes namespace that the selector should match.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation
func (s FargateProfileSelector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FargateProfileSelector) MarshalFields(e protocol.FieldEncoder) error {
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "labels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing an identity provider for authentication credentials.
type Identity struct {
	_ struct{} `type:"structure"`

	// The OpenID Connect (https://openid.net/connect/) identity provider information
	// for the cluster.
	Oidc *OIDC `locationName:"oidc" type:"structure"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Identity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Oidc != nil {
		v := s.Oidc

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "oidc", v, metadata)
	}
	return nil
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * AutoScalingGroupNotFound: We couldn't find the Auto Scaling group associated
	//    with the managed node group. You may be able to recreate an Auto Scaling
	//    group with the same settings to recover.
	//
	//    * Ec2SecurityGroupNotFound: We couldn't find the cluster security group
	//    for the cluster. You must recreate your cluster.
	//
	//    * Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//    security group for your managed node group. Remove any dependencies from
	//    the security group.
	//
	//    * Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//    for your managed node group. You may be able to recreate a launch template
	//    with the same settings to recover.
	//
	//    * Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//    for your managed node group does not match the version that Amazon EKS
	//    created. You may be able to revert to the version that Amazon EKS created
	//    to recover.
	//
	//    * IamInstanceProfileNotFound: We couldn't find the IAM instance profile
	//    for your managed node group. You may be able to recreate an instance profile
	//    with the same settings to recover.
	//
	//    * IamNodeRoleNotFound: We couldn't find the IAM role for your managed
	//    node group. You may be able to recreate an IAM role with the same settings
	//    to recover.
	//
	//    * AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//    while attempting to launch instances.
	//
	//    * NodeCreationFailure: Your launched instances are unable to register
	//    with your Amazon EKS cluster. Common causes of this failure are insufficient
	//    worker node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	//    permissions or lack of outbound internet access for the nodes.
	//
	//    * InstanceLimitExceeded: Your AWS account is unable to launch any more
	//    instances of the specified instance type. You may be able to request an
	//    Amazon EC2 instance limit increase to recover.
	//
	//    * InsufficientFreeAddresses: One or more of the subnets associated with
	//    your managed node group does not have enough available IP addresses for
	//    new nodes.
	//
	//    * AccessDenied: Amazon EKS or one or more of your managed nodes is unable
	//    to communicate with your cluster API server.
	//
	//    * InternalFailure: These errors are usually caused by an Amazon EKS server-side
	//    issue.
	Code NodegroupIssueCode `locationName:"code" type:"string" enum:"true"`

	// The error message associated with the issue.
	Message *string `locationName:"message" type:"string"`

	// The AWS resources that are afflicted by this issue.
	ResourceIds []string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation
func (s Issue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Issue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceIds != nil {
		v := s.ResourceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {
	_ struct{} `type:"structure"`

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs. If a log type isn't enabled, that log type doesn't export
	// its control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The available cluster control plane log types.
	Types []LogType `locationName:"types" type:"list"`
}

// String returns the string representation
func (s LogSetup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogSetup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if s.Types != nil {
		v := s.Types

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "types", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {
	_ struct{} `type:"structure"`

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []LogSetup `locationName:"clusterLogging" type:"list"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Logging) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClusterLogging != nil {
		v := s.ClusterLogging

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "clusterLogging", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {
	_ struct{} `type:"structure"`

	// The AMI type associated with your node group. GPU instance types should use
	// the AL2_x86_64_GPU AMI type, which uses the Amazon EKS-optimized Linux AMI
	// with GPU support. Non-GPU instances should use the AL2_x86_64 AMI type, which
	// uses the Amazon EKS-optimized Linux AMI.
	AmiType AMITypes `locationName:"amiType" type:"string" enum:"true"`

	// The name of the cluster that the managed node group resides in.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the managed node group was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The root device disk size (in GiB) for your node group instances. The default
	// disk size is 20 GiB.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth `locationName:"health" type:"structure"`

	// The instance types associated with your node group.
	InstanceTypes []string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There
	// may be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]string `locationName:"labels" type:"map"`

	// The Unix epoch timestamp in seconds for when the managed node group was last
	// modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The IAM role associated with your node group. The Amazon EKS worker node
	// kubelet daemon makes calls to AWS APIs on your behalf. Worker nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies. Before you can launch worker nodes and register them into a cluster,
	// you must create an IAM role for those worker nodes to use when they are launched.
	// For more information, see Amazon EKS Worker Node IAM Role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	// in the Amazon EKS User Guide .
	NodeRole *string `locationName:"nodeRole" type:"string"`

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string `locationName:"nodegroupArn" type:"string"`

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The AMI version of the managed node group. For more information, see Amazon
	// EKS-Optimized Linux AMI Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The remote access (SSH) configuration that is associated with the node group.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The resources associated with the node group, such as Auto Scaling groups
	// and security groups for remote access.
	Resources *NodegroupResources `locationName:"resources" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The current status of the managed node group.
	Status NodegroupStatus `locationName:"status" type:"string" enum:"true"`

	// The subnets allowed for the Auto Scaling group that is associated with your
	// node group. These subnets must have the following tag: kubernetes.io/cluster/CLUSTER_NAME,
	// where CLUSTER_NAME is replaced with the name of your cluster.
	Subnets []string `locationName:"subnets" type:"list"`

	// The metadata applied to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes version of the managed node group.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Nodegroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Nodegroup) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AmiType) > 0 {
		v := s.AmiType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "amiType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clusterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DiskSize != nil {
		v := *s.DiskSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "diskSize", protocol.Int64Value(v), metadata)
	}
	if s.Health != nil {
		v := s.Health

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "health", v, metadata)
	}
	if s.InstanceTypes != nil {
		v := s.InstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "labels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ModifiedAt != nil {
		v := *s.ModifiedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modifiedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.NodeRole != nil {
		v := *s.NodeRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodeRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupArn != nil {
		v := *s.NodegroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodegroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupName != nil {
		v := *s.NodegroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodegroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReleaseVersion != nil {
		v := *s.ReleaseVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "releaseVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RemoteAccess != nil {
		v := s.RemoteAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteAccess", v, metadata)
	}
	if s.Resources != nil {
		v := s.Resources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resources", v, metadata)
	}
	if s.ScalingConfig != nil {
		v := s.ScalingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scalingConfig", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the health status of the node group.
type NodegroupHealth struct {
	_ struct{} `type:"structure"`

	// Any issues that are associated with the node group.
	Issues []Issue `locationName:"issues" type:"list"`
}

// String returns the string representation
func (s NodegroupHealth) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodegroupHealth) MarshalFields(e protocol.FieldEncoder) error {
	if s.Issues != nil {
		v := s.Issues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "issues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing the resources associated with the node group, such
// as Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the worker nodes.
	RemoteAccessSecurityGroup *string `locationName:"remoteAccessSecurityGroup" type:"string"`
}

// String returns the string representation
func (s NodegroupResources) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodegroupResources) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoScalingGroups != nil {
		v := s.AutoScalingGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "autoScalingGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RemoteAccessSecurityGroup != nil {
		v := *s.RemoteAccessSecurityGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "remoteAccessSecurityGroup", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group.
type NodegroupScalingConfig struct {
	_ struct{} `type:"structure"`

	// The current number of worker nodes that the managed node group should maintain.
	DesiredSize *int64 `locationName:"desiredSize" min:"1" type:"integer"`

	// The maximum number of worker nodes that the managed node group can scale
	// out to. Managed node groups can support up to 100 nodes by default.
	MaxSize *int64 `locationName:"maxSize" min:"1" type:"integer"`

	// The minimum number of worker nodes that the managed node group can scale
	// in to. This number must be greater than zero.
	MinSize *int64 `locationName:"minSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s NodegroupScalingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupScalingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodegroupScalingConfig"}
	if s.DesiredSize != nil && *s.DesiredSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DesiredSize", 1))
	}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxSize", 1))
	}
	if s.MinSize != nil && *s.MinSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodegroupScalingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DesiredSize != nil {
		v := *s.DesiredSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "desiredSize", protocol.Int64Value(v), metadata)
	}
	if s.MaxSize != nil {
		v := *s.MaxSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxSize", protocol.Int64Value(v), metadata)
	}
	if s.MinSize != nil {
		v := *s.MinSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the OpenID Connect (https://openid.net/connect/) identity
// provider information for the cluster.
type OIDC struct {
	_ struct{} `type:"structure"`

	// The issuer URL for the OpenID Connect identity provider.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation
func (s OIDC) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OIDC) MarshalFields(e protocol.FieldEncoder) error {
	if s.Issuer != nil {
		v := *s.Issuer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "issuer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifies the AWS Key Management Service (AWS KMS) customer master key (CMK)
// used to encrypt the secrets.
type Provider struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) or alias of the customer master key (CMK). The
	// CMK must be symmetric, created in the same region as the cluster, and if
	// the CMK was created in a different account, the user must have access to
	// the CMK. For more information, see Allowing Users in Other Accounts to Use
	// a CMK (https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html)
	// in the AWS Key Management Service Developer Guide.
	KeyArn *string `locationName:"keyArn" type:"string"`
}

// String returns the string representation
func (s Provider) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Provider) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyArn != nil {
		v := *s.KeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 SSH key that provides access for SSH communication with the
	// worker nodes in the managed node group. For more information, see Amazon
	// EC2 Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
	Ec2SshKey *string `locationName:"ec2SshKey" type:"string"`

	// The security groups that are allowed SSH access (port 22) to the worker nodes.
	// If you specify an Amazon EC2 SSH key but do not specify a source security
	// group when you create a managed node group, then port 22 on the worker nodes
	// is opened to the internet (0.0.0.0/0). For more information, see Security
	// Groups for Your VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceSecurityGroups []string `locationName:"sourceSecurityGroups" type:"list"`
}

// String returns the string representation
func (s RemoteAccessConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoteAccessConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Ec2SshKey != nil {
		v := *s.Ec2SshKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ec2SshKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceSecurityGroups != nil {
		v := s.SourceSecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sourceSecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing an asynchronous update.
type Update struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the update was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Any errors associated with a Failed update.
	Errors []ErrorDetail `locationName:"errors" type:"list"`

	// A UUID that is used to track the update.
	Id *string `locationName:"id" type:"string"`

	// A key-value map that contains the parameters associated with the update.
	Params []UpdateParam `locationName:"params" type:"list"`

	// The current status of the update.
	Status UpdateStatus `locationName:"status" type:"string" enum:"true"`

	// The type of the update.
	Type UpdateType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Update) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Params != nil {
		v := s.Params

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "params", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {
	_ struct{} `type:"structure"`

	// Kubernetes labels to be added or updated.
	AddOrUpdateLabels map[string]string `locationName:"addOrUpdateLabels" type:"map"`

	// Kubernetes labels to be removed.
	RemoveLabels []string `locationName:"removeLabels" type:"list"`
}

// String returns the string representation
func (s UpdateLabelsPayload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateLabelsPayload) MarshalFields(e protocol.FieldEncoder) error {
	if s.AddOrUpdateLabels != nil {
		v := s.AddOrUpdateLabels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "addOrUpdateLabels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RemoveLabels != nil {
		v := s.RemoveLabels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "removeLabels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing the details of an update request.
type UpdateParam struct {
	_ struct{} `type:"structure"`

	// The keys associated with an update request.
	Type UpdateParamType `locationName:"type" type:"string" enum:"true"`

	// The value of the keys submitted as part of an update request.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s UpdateParam) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateParam) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {
	_ struct{} `type:"structure"`

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests
	// from within your cluster's VPC use the private VPC endpoint. The default
	// value for this parameter is false, which disables private access for your
	// Kubernetes API server. If you disable private access and you have worker
	// nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the worker nodes
	// or Fargate pods. For more information, see Amazon EKS Cluster Endpoint Access
	// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes
	// API server can only receive requests from within the cluster VPC. The default
	// value for this parameter is true, which enables public access for your Kubernetes
	// API server. For more information, see Amazon EKS Cluster Endpoint Access
	// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0.
	// If you've disabled private endpoint access and you have worker nodes or AWS
	// Fargate pods in the cluster, then ensure that you specify the necessary CIDR
	// blocks. For more information, see Amazon EKS Cluster Endpoint Access Control
	// (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []string `locationName:"publicAccessCidrs" type:"list"`

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use to allow communication between
	// your worker nodes and the Kubernetes control plane. If you don't specify
	// a security group, the default security group for your VPC is used.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// Specify subnets for your Amazon EKS worker nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between
	// your worker nodes and the Kubernetes control plane.
	SubnetIds []string `locationName:"subnetIds" type:"list"`
}

// String returns the string representation
func (s VpcConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndpointPrivateAccess != nil {
		v := *s.EndpointPrivateAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointPrivateAccess", protocol.BoolValue(v), metadata)
	}
	if s.EndpointPublicAccess != nil {
		v := *s.EndpointPublicAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointPublicAccess", protocol.BoolValue(v), metadata)
	}
	if s.PublicAccessCidrs != nil {
		v := s.PublicAccessCidrs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "publicAccessCidrs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string `locationName:"clusterSecurityGroupId" type:"string"`

	// This parameter indicates whether the Amazon EKS private API server endpoint
	// is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private
	// VPC endpoint instead of traversing the internet. If this value is disabled
	// and you have worker nodes or AWS Fargate pods in the cluster, then ensure
	// that publicAccessCidrs includes the necessary CIDR blocks for communication
	// with the worker nodes or Fargate pods. For more information, see Amazon EKS
	// Cluster Endpoint Access Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// This parameter indicates whether the Amazon EKS public API server endpoint
	// is enabled. If the Amazon EKS public API server endpoint is disabled, your
	// cluster's Kubernetes API server can only receive requests that originate
	// from within the cluster VPC.
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the listed CIDR blocks is denied. The default value is 0.0.0.0/0. If you've
	// disabled private endpoint access and you have worker nodes or AWS Fargate
	// pods in the cluster, then ensure that the necessary CIDR blocks are listed.
	// For more information, see Amazon EKS Cluster Endpoint Access Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []string `locationName:"publicAccessCidrs" type:"list"`

	// The security groups associated with the cross-account elastic network interfaces
	// that are used to allow communication between your worker nodes and the Kubernetes
	// control plane.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// The subnets associated with your cluster.
	SubnetIds []string `locationName:"subnetIds" type:"list"`

	// The VPC associated with your cluster.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClusterSecurityGroupId != nil {
		v := *s.ClusterSecurityGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clusterSecurityGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointPrivateAccess != nil {
		v := *s.EndpointPrivateAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointPrivateAccess", protocol.BoolValue(v), metadata)
	}
	if s.EndpointPublicAccess != nil {
		v := *s.EndpointPublicAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointPublicAccess", protocol.BoolValue(v), metadata)
	}
	if s.PublicAccessCidrs != nil {
		v := s.PublicAccessCidrs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "publicAccessCidrs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
