// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchStopUpdateActionInput struct {
	_ struct{} `type:"structure"`

	// The cache cluster IDs
	CacheClusterIds []string `type:"list"`

	// The replication group IDs
	ReplicationGroupIds []string `type:"list"`

	// The unique ID of the service update
	//
	// ServiceUpdateName is a required field
	ServiceUpdateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BatchStopUpdateActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStopUpdateActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchStopUpdateActionInput"}

	if s.ServiceUpdateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceUpdateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchStopUpdateActionOutput struct {
	_ struct{} `type:"structure"`

	// Update actions that have been processed successfully
	ProcessedUpdateActions []ProcessedUpdateAction `locationNameList:"ProcessedUpdateAction" type:"list"`

	// Update actions that haven't been processed successfully
	UnprocessedUpdateActions []UnprocessedUpdateAction `locationNameList:"UnprocessedUpdateAction" type:"list"`
}

// String returns the string representation
func (s BatchStopUpdateActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchStopUpdateAction = "BatchStopUpdateAction"

// BatchStopUpdateActionRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Stop the service update. For more information on service updates and stopping
// them, see Stopping Service Updates (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
//
//    // Example sending a request using BatchStopUpdateActionRequest.
//    req := client.BatchStopUpdateActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction
func (c *Client) BatchStopUpdateActionRequest(input *BatchStopUpdateActionInput) BatchStopUpdateActionRequest {
	op := &aws.Operation{
		Name:       opBatchStopUpdateAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchStopUpdateActionInput{}
	}

	req := c.newRequest(op, input, &BatchStopUpdateActionOutput{})

	return BatchStopUpdateActionRequest{Request: req, Input: input, Copy: c.BatchStopUpdateActionRequest}
}

// BatchStopUpdateActionRequest is the request type for the
// BatchStopUpdateAction API operation.
type BatchStopUpdateActionRequest struct {
	*aws.Request
	Input *BatchStopUpdateActionInput
	Copy  func(*BatchStopUpdateActionInput) BatchStopUpdateActionRequest
}

// Send marshals and sends the BatchStopUpdateAction API request.
func (r BatchStopUpdateActionRequest) Send(ctx context.Context) (*BatchStopUpdateActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchStopUpdateActionResponse{
		BatchStopUpdateActionOutput: r.Request.Data.(*BatchStopUpdateActionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchStopUpdateActionResponse is the response type for the
// BatchStopUpdateAction API operation.
type BatchStopUpdateActionResponse struct {
	*BatchStopUpdateActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchStopUpdateAction request.
func (r *BatchStopUpdateActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
