// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// Provides details of the Global Datastore
	GlobalReplicationGroupDescription *string `type:"string"`

	// The suffix name of a Global Datastore. The suffix guarantees uniqueness of
	// the Global Datastore name across multiple regions.
	//
	// GlobalReplicationGroupIdSuffix is a required field
	GlobalReplicationGroupIdSuffix *string `type:"string" required:"true"`

	// The name of the primary cluster that accepts writes and will replicate updates
	// to the secondary cluster.
	//
	// PrimaryReplicationGroupId is a required field
	PrimaryReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalReplicationGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGlobalReplicationGroupInput"}

	if s.GlobalReplicationGroupIdSuffix == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalReplicationGroupIdSuffix"))
	}

	if s.PrimaryReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrimaryReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateGlobalReplicationGroup = "CreateGlobalReplicationGroup"

// CreateGlobalReplicationGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Global Datastore for Redis offers fully managed, fast, reliable and secure
// cross-region replication. Using Global Datastore for Redis, you can create
// cross-region read replica clusters for ElastiCache for Redis to enable low-latency
// reads and disaster recovery across regions. For more information, see Replication
// Across Regions Using Global Datastore (/AmazonElastiCache/latest/red-ug/Redis-Global-Clusters.html).
//
//    * The GlobalReplicationGroupIdSuffix is the name of the Global Datastore.
//
//    * The PrimaryReplicationGroupId represents the name of the primary cluster
//    that accepts writes and will replicate updates to the secondary cluster.
//
//    // Example sending a request using CreateGlobalReplicationGroupRequest.
//    req := client.CreateGlobalReplicationGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup
func (c *Client) CreateGlobalReplicationGroupRequest(input *CreateGlobalReplicationGroupInput) CreateGlobalReplicationGroupRequest {
	op := &aws.Operation{
		Name:       opCreateGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGlobalReplicationGroupInput{}
	}

	req := c.newRequest(op, input, &CreateGlobalReplicationGroupOutput{})

	return CreateGlobalReplicationGroupRequest{Request: req, Input: input, Copy: c.CreateGlobalReplicationGroupRequest}
}

// CreateGlobalReplicationGroupRequest is the request type for the
// CreateGlobalReplicationGroup API operation.
type CreateGlobalReplicationGroupRequest struct {
	*aws.Request
	Input *CreateGlobalReplicationGroupInput
	Copy  func(*CreateGlobalReplicationGroupInput) CreateGlobalReplicationGroupRequest
}

// Send marshals and sends the CreateGlobalReplicationGroup API request.
func (r CreateGlobalReplicationGroupRequest) Send(ctx context.Context) (*CreateGlobalReplicationGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGlobalReplicationGroupResponse{
		CreateGlobalReplicationGroupOutput: r.Request.Data.(*CreateGlobalReplicationGroupOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGlobalReplicationGroupResponse is the response type for the
// CreateGlobalReplicationGroup API operation.
type CreateGlobalReplicationGroupResponse struct {
	*CreateGlobalReplicationGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGlobalReplicationGroup request.
func (r *CreateGlobalReplicationGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
