// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeGlobalReplicationGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	GlobalReplicationGroupId *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// Returns the list of members that comprise the Global Datastore.
	ShowMemberInfo *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeGlobalReplicationGroupsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeGlobalReplicationGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the slot configuration and global identifier for each slice group.
	GlobalReplicationGroups []GlobalReplicationGroup `locationNameList:"GlobalReplicationGroup" type:"list"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	// >
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeGlobalReplicationGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGlobalReplicationGroups = "DescribeGlobalReplicationGroups"

// DescribeGlobalReplicationGroupsRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Returns information about a particular global replication group. If no identifier
// is specified, returns information about all Global Datastores.
//
//    // Example sending a request using DescribeGlobalReplicationGroupsRequest.
//    req := client.DescribeGlobalReplicationGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups
func (c *Client) DescribeGlobalReplicationGroupsRequest(input *DescribeGlobalReplicationGroupsInput) DescribeGlobalReplicationGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeGlobalReplicationGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGlobalReplicationGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeGlobalReplicationGroupsOutput{})

	return DescribeGlobalReplicationGroupsRequest{Request: req, Input: input, Copy: c.DescribeGlobalReplicationGroupsRequest}
}

// DescribeGlobalReplicationGroupsRequest is the request type for the
// DescribeGlobalReplicationGroups API operation.
type DescribeGlobalReplicationGroupsRequest struct {
	*aws.Request
	Input *DescribeGlobalReplicationGroupsInput
	Copy  func(*DescribeGlobalReplicationGroupsInput) DescribeGlobalReplicationGroupsRequest
}

// Send marshals and sends the DescribeGlobalReplicationGroups API request.
func (r DescribeGlobalReplicationGroupsRequest) Send(ctx context.Context) (*DescribeGlobalReplicationGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGlobalReplicationGroupsResponse{
		DescribeGlobalReplicationGroupsOutput: r.Request.Data.(*DescribeGlobalReplicationGroupsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeGlobalReplicationGroupsRequestPaginator returns a paginator for DescribeGlobalReplicationGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeGlobalReplicationGroupsRequest(input)
//   p := elasticache.NewDescribeGlobalReplicationGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeGlobalReplicationGroupsPaginator(req DescribeGlobalReplicationGroupsRequest) DescribeGlobalReplicationGroupsPaginator {
	return DescribeGlobalReplicationGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeGlobalReplicationGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeGlobalReplicationGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeGlobalReplicationGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeGlobalReplicationGroupsPaginator) CurrentPage() *DescribeGlobalReplicationGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeGlobalReplicationGroupsOutput)
}

// DescribeGlobalReplicationGroupsResponse is the response type for the
// DescribeGlobalReplicationGroups API operation.
type DescribeGlobalReplicationGroupsResponse struct {
	*DescribeGlobalReplicationGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGlobalReplicationGroups request.
func (r *DescribeGlobalReplicationGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
