// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The name of the secondary cluster you wish to remove from the Global Datastore
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// The AWS region of secondary cluster you wish to remove from the Global Datastore
	//
	// ReplicationGroupRegion is a required field
	ReplicationGroupRegion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateGlobalReplicationGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateGlobalReplicationGroupInput"}

	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalReplicationGroupId"))
	}

	if s.ReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroupId"))
	}

	if s.ReplicationGroupRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroupRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DisassociateGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateGlobalReplicationGroup = "DisassociateGlobalReplicationGroup"

// DisassociateGlobalReplicationGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Remove a secondary cluster from the Global Datastore using the Global Datastore
// name. The secondary cluster will no longer receive updates from the primary
// cluster, but will remain as a standalone cluster in that AWS region.
//
//    // Example sending a request using DisassociateGlobalReplicationGroupRequest.
//    req := client.DisassociateGlobalReplicationGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup
func (c *Client) DisassociateGlobalReplicationGroupRequest(input *DisassociateGlobalReplicationGroupInput) DisassociateGlobalReplicationGroupRequest {
	op := &aws.Operation{
		Name:       opDisassociateGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateGlobalReplicationGroupInput{}
	}

	req := c.newRequest(op, input, &DisassociateGlobalReplicationGroupOutput{})

	return DisassociateGlobalReplicationGroupRequest{Request: req, Input: input, Copy: c.DisassociateGlobalReplicationGroupRequest}
}

// DisassociateGlobalReplicationGroupRequest is the request type for the
// DisassociateGlobalReplicationGroup API operation.
type DisassociateGlobalReplicationGroupRequest struct {
	*aws.Request
	Input *DisassociateGlobalReplicationGroupInput
	Copy  func(*DisassociateGlobalReplicationGroupInput) DisassociateGlobalReplicationGroupRequest
}

// Send marshals and sends the DisassociateGlobalReplicationGroup API request.
func (r DisassociateGlobalReplicationGroupRequest) Send(ctx context.Context) (*DisassociateGlobalReplicationGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateGlobalReplicationGroupResponse{
		DisassociateGlobalReplicationGroupOutput: r.Request.Data.(*DisassociateGlobalReplicationGroupOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateGlobalReplicationGroupResponse is the response type for the
// DisassociateGlobalReplicationGroup API operation.
type DisassociateGlobalReplicationGroupResponse struct {
	*DisassociateGlobalReplicationGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateGlobalReplicationGroup request.
func (r *DisassociateGlobalReplicationGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
