// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ModifyCacheSubnetGroup operation.
type ModifyCacheSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name for the cache subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// Example: mysubnetgroup
	//
	// CacheSubnetGroupName is a required field
	CacheSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the cache subnet group.
	SubnetIds []string `locationNameList:"SubnetIdentifier" type:"list"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCacheSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyCacheSubnetGroupInput"}

	if s.CacheSubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyCacheSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * CreateCacheSubnetGroup
	//
	//    * ModifyCacheSubnetGroup
	CacheSubnetGroup *CacheSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyCacheSubnetGroup = "ModifyCacheSubnetGroup"

// ModifyCacheSubnetGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Modifies an existing cache subnet group.
//
//    // Example sending a request using ModifyCacheSubnetGroupRequest.
//    req := client.ModifyCacheSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup
func (c *Client) ModifyCacheSubnetGroupRequest(input *ModifyCacheSubnetGroupInput) ModifyCacheSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opModifyCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyCacheSubnetGroupOutput{})

	return ModifyCacheSubnetGroupRequest{Request: req, Input: input, Copy: c.ModifyCacheSubnetGroupRequest}
}

// ModifyCacheSubnetGroupRequest is the request type for the
// ModifyCacheSubnetGroup API operation.
type ModifyCacheSubnetGroupRequest struct {
	*aws.Request
	Input *ModifyCacheSubnetGroupInput
	Copy  func(*ModifyCacheSubnetGroupInput) ModifyCacheSubnetGroupRequest
}

// Send marshals and sends the ModifyCacheSubnetGroup API request.
func (r ModifyCacheSubnetGroupRequest) Send(ctx context.Context) (*ModifyCacheSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyCacheSubnetGroupResponse{
		ModifyCacheSubnetGroupOutput: r.Request.Data.(*ModifyCacheSubnetGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyCacheSubnetGroupResponse is the response type for the
// ModifyCacheSubnetGroup API operation.
type ModifyCacheSubnetGroupResponse struct {
	*ModifyCacheSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyCacheSubnetGroup request.
func (r *ModifyCacheSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
