// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Request to delete a draft environment configuration.
type DeleteEnvironmentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application the environment is associated with.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to delete the draft configuration from.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEnvironmentConfigurationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.EnvironmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEnvironmentConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEnvironmentConfiguration = "DeleteEnvironmentConfiguration"

// DeleteEnvironmentConfigurationRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Deletes the draft configuration associated with the running environment.
//
// Updating a running environment with any configuration changes creates a draft
// configuration set. You can get the draft configuration using DescribeConfigurationSettings
// while the update is in progress or if the update fails. The DeploymentStatus
// for the draft configuration indicates whether the deployment is in process
// or has failed. The draft configuration remains in existence until it is deleted
// with this action.
//
//    // Example sending a request using DeleteEnvironmentConfigurationRequest.
//    req := client.DeleteEnvironmentConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration
func (c *Client) DeleteEnvironmentConfigurationRequest(input *DeleteEnvironmentConfigurationInput) DeleteEnvironmentConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteEnvironmentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteEnvironmentConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteEnvironmentConfigurationRequest{Request: req, Input: input, Copy: c.DeleteEnvironmentConfigurationRequest}
}

// DeleteEnvironmentConfigurationRequest is the request type for the
// DeleteEnvironmentConfiguration API operation.
type DeleteEnvironmentConfigurationRequest struct {
	*aws.Request
	Input *DeleteEnvironmentConfigurationInput
	Copy  func(*DeleteEnvironmentConfigurationInput) DeleteEnvironmentConfigurationRequest
}

// Send marshals and sends the DeleteEnvironmentConfiguration API request.
func (r DeleteEnvironmentConfigurationRequest) Send(ctx context.Context) (*DeleteEnvironmentConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEnvironmentConfigurationResponse{
		DeleteEnvironmentConfigurationOutput: r.Request.Data.(*DeleteEnvironmentConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEnvironmentConfigurationResponse is the response type for the
// DeleteEnvironmentConfiguration API operation.
type DeleteEnvironmentConfigurationResponse struct {
	*DeleteEnvironmentConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEnvironmentConfiguration request.
func (r *DeleteEnvironmentConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
