// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeletePlatformVersionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the version of the custom platform.
	PlatformArn *string `type:"string"`
}

// String returns the string representation
func (s DeletePlatformVersionInput) String() string {
	return awsutil.Prettify(s)
}

type DeletePlatformVersionOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the version of the custom platform.
	PlatformSummary *PlatformSummary `type:"structure"`
}

// String returns the string representation
func (s DeletePlatformVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePlatformVersion = "DeletePlatformVersion"

// DeletePlatformVersionRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Deletes the specified version of a custom platform.
//
//    // Example sending a request using DeletePlatformVersionRequest.
//    req := client.DeletePlatformVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion
func (c *Client) DeletePlatformVersionRequest(input *DeletePlatformVersionInput) DeletePlatformVersionRequest {
	op := &aws.Operation{
		Name:       opDeletePlatformVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlatformVersionInput{}
	}

	req := c.newRequest(op, input, &DeletePlatformVersionOutput{})

	return DeletePlatformVersionRequest{Request: req, Input: input, Copy: c.DeletePlatformVersionRequest}
}

// DeletePlatformVersionRequest is the request type for the
// DeletePlatformVersion API operation.
type DeletePlatformVersionRequest struct {
	*aws.Request
	Input *DeletePlatformVersionInput
	Copy  func(*DeletePlatformVersionInput) DeletePlatformVersionRequest
}

// Send marshals and sends the DeletePlatformVersion API request.
func (r DeletePlatformVersionRequest) Send(ctx context.Context) (*DeletePlatformVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePlatformVersionResponse{
		DeletePlatformVersionOutput: r.Request.Data.(*DeletePlatformVersionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePlatformVersionResponse is the response type for the
// DeletePlatformVersion API operation.
type DeletePlatformVersionResponse struct {
	*DeletePlatformVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePlatformVersion request.
func (r *DeletePlatformVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
