// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to list completed and failed managed actions.
type DescribeEnvironmentManagedActionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The maximum number of items to return for a single request.
	MaxItems *int64 `type:"integer"`

	// The pagination token returned by a previous request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentManagedActionHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEnvironmentManagedActionHistoryInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A result message containing a list of completed and failed managed actions.
type DescribeEnvironmentManagedActionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list of completed and failed managed actions.
	ManagedActionHistoryItems []ManagedActionHistoryItem `min:"1" type:"list"`

	// A pagination token that you pass to DescribeEnvironmentManagedActionHistory
	// to get the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEnvironmentManagedActionHistory = "DescribeEnvironmentManagedActionHistory"

// DescribeEnvironmentManagedActionHistoryRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Lists an environment's completed and failed managed actions.
//
//    // Example sending a request using DescribeEnvironmentManagedActionHistoryRequest.
//    req := client.DescribeEnvironmentManagedActionHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory
func (c *Client) DescribeEnvironmentManagedActionHistoryRequest(input *DescribeEnvironmentManagedActionHistoryInput) DescribeEnvironmentManagedActionHistoryRequest {
	op := &aws.Operation{
		Name:       opDescribeEnvironmentManagedActionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEnvironmentManagedActionHistoryInput{}
	}

	req := c.newRequest(op, input, &DescribeEnvironmentManagedActionHistoryOutput{})

	return DescribeEnvironmentManagedActionHistoryRequest{Request: req, Input: input, Copy: c.DescribeEnvironmentManagedActionHistoryRequest}
}

// DescribeEnvironmentManagedActionHistoryRequest is the request type for the
// DescribeEnvironmentManagedActionHistory API operation.
type DescribeEnvironmentManagedActionHistoryRequest struct {
	*aws.Request
	Input *DescribeEnvironmentManagedActionHistoryInput
	Copy  func(*DescribeEnvironmentManagedActionHistoryInput) DescribeEnvironmentManagedActionHistoryRequest
}

// Send marshals and sends the DescribeEnvironmentManagedActionHistory API request.
func (r DescribeEnvironmentManagedActionHistoryRequest) Send(ctx context.Context) (*DescribeEnvironmentManagedActionHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEnvironmentManagedActionHistoryResponse{
		DescribeEnvironmentManagedActionHistoryOutput: r.Request.Data.(*DescribeEnvironmentManagedActionHistoryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeEnvironmentManagedActionHistoryRequestPaginator returns a paginator for DescribeEnvironmentManagedActionHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeEnvironmentManagedActionHistoryRequest(input)
//   p := elasticbeanstalk.NewDescribeEnvironmentManagedActionHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeEnvironmentManagedActionHistoryPaginator(req DescribeEnvironmentManagedActionHistoryRequest) DescribeEnvironmentManagedActionHistoryPaginator {
	return DescribeEnvironmentManagedActionHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeEnvironmentManagedActionHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeEnvironmentManagedActionHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeEnvironmentManagedActionHistoryPaginator struct {
	aws.Pager
}

func (p *DescribeEnvironmentManagedActionHistoryPaginator) CurrentPage() *DescribeEnvironmentManagedActionHistoryOutput {
	return p.Pager.CurrentPage().(*DescribeEnvironmentManagedActionHistoryOutput)
}

// DescribeEnvironmentManagedActionHistoryResponse is the response type for the
// DescribeEnvironmentManagedActionHistory API operation.
type DescribeEnvironmentManagedActionHistoryResponse struct {
	*DescribeEnvironmentManagedActionHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEnvironmentManagedActionHistory request.
func (r *DescribeEnvironmentManagedActionHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
