// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Request to disassociate the operations role from an environment.
type DisassociateEnvironmentOperationsRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment from which to disassociate the operations role.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateEnvironmentOperationsRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateEnvironmentOperationsRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateEnvironmentOperationsRoleInput"}

	if s.EnvironmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateEnvironmentOperationsRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateEnvironmentOperationsRoleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateEnvironmentOperationsRole = "DisassociateEnvironmentOperationsRole"

// DisassociateEnvironmentOperationsRoleRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Disassociate the operations role from an environment. After this call is
// made, Elastic Beanstalk uses the caller's permissions for permissions to
// downstream services during subsequent calls acting on this environment. For
// more information, see Operations roles (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html)
// in the AWS Elastic Beanstalk Developer Guide.
//
//    // Example sending a request using DisassociateEnvironmentOperationsRoleRequest.
//    req := client.DisassociateEnvironmentOperationsRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole
func (c *Client) DisassociateEnvironmentOperationsRoleRequest(input *DisassociateEnvironmentOperationsRoleInput) DisassociateEnvironmentOperationsRoleRequest {
	op := &aws.Operation{
		Name:       opDisassociateEnvironmentOperationsRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateEnvironmentOperationsRoleInput{}
	}

	req := c.newRequest(op, input, &DisassociateEnvironmentOperationsRoleOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateEnvironmentOperationsRoleRequest{Request: req, Input: input, Copy: c.DisassociateEnvironmentOperationsRoleRequest}
}

// DisassociateEnvironmentOperationsRoleRequest is the request type for the
// DisassociateEnvironmentOperationsRole API operation.
type DisassociateEnvironmentOperationsRoleRequest struct {
	*aws.Request
	Input *DisassociateEnvironmentOperationsRoleInput
	Copy  func(*DisassociateEnvironmentOperationsRoleInput) DisassociateEnvironmentOperationsRoleRequest
}

// Send marshals and sends the DisassociateEnvironmentOperationsRole API request.
func (r DisassociateEnvironmentOperationsRoleRequest) Send(ctx context.Context) (*DisassociateEnvironmentOperationsRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateEnvironmentOperationsRoleResponse{
		DisassociateEnvironmentOperationsRoleOutput: r.Request.Data.(*DisassociateEnvironmentOperationsRoleOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateEnvironmentOperationsRoleResponse is the response type for the
// DisassociateEnvironmentOperationsRole API operation.
type DisassociateEnvironmentOperationsRoleResponse struct {
	*DisassociateEnvironmentOperationsRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateEnvironmentOperationsRole request.
func (r *DisassociateEnvironmentOperationsRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
