// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPlatformBranchesInput struct {
	_ struct{} `type:"structure"`

	// Criteria for restricting the resulting list of platform branches. The filter
	// is evaluated as a logical conjunction (AND) of the separate SearchFilter
	// terms.
	//
	// The following list shows valid attribute values for each of the SearchFilter
	// terms. Most operators take a single value. The in and not_in operators can
	// take multiple values.
	//
	//    * Attribute = BranchName: Operator: = | != | begins_with | ends_with |
	//    contains | in | not_in
	//
	//    * Attribute = LifecycleState: Operator: = | != | in | not_in Values: beta
	//    | supported | deprecated | retired
	//
	//    * Attribute = PlatformName: Operator: = | != | begins_with | ends_with
	//    | contains | in | not_in
	//
	//    * Attribute = TierType: Operator: = | != Values: WebServer/Standard |
	//    Worker/SQS/HTTP
	//
	// Array size: limited to 10 SearchFilter objects.
	//
	// Within each SearchFilter item, the Values array is limited to 10 items.
	Filters []SearchFilter `type:"list"`

	// The maximum number of platform branch values returned in one call.
	MaxRecords *int64 `min:"1" type:"integer"`

	// For a paginated request. Specify a token from a previous response page to
	// retrieve the next response page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If no NextToken is specified, the first page is retrieved.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPlatformBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlatformBranchesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPlatformBranchesInput"}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPlatformBranchesOutput struct {
	_ struct{} `type:"structure"`

	// In a paginated request, if this value isn't null, it's the token that you
	// can pass in a subsequent request to get the next response page.
	NextToken *string `type:"string"`

	// Summary information about the platform branches.
	PlatformBranchSummaryList []PlatformBranchSummary `type:"list"`
}

// String returns the string representation
func (s ListPlatformBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPlatformBranches = "ListPlatformBranches"

// ListPlatformBranchesRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Lists the platform branches available for your account in an AWS Region.
// Provides summary information about each platform branch.
//
// For definitions of platform branch and other platform-related terms, see
// AWS Elastic Beanstalk Platforms Glossary (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
//
//    // Example sending a request using ListPlatformBranchesRequest.
//    req := client.ListPlatformBranchesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches
func (c *Client) ListPlatformBranchesRequest(input *ListPlatformBranchesInput) ListPlatformBranchesRequest {
	op := &aws.Operation{
		Name:       opListPlatformBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlatformBranchesInput{}
	}

	req := c.newRequest(op, input, &ListPlatformBranchesOutput{})

	return ListPlatformBranchesRequest{Request: req, Input: input, Copy: c.ListPlatformBranchesRequest}
}

// ListPlatformBranchesRequest is the request type for the
// ListPlatformBranches API operation.
type ListPlatformBranchesRequest struct {
	*aws.Request
	Input *ListPlatformBranchesInput
	Copy  func(*ListPlatformBranchesInput) ListPlatformBranchesRequest
}

// Send marshals and sends the ListPlatformBranches API request.
func (r ListPlatformBranchesRequest) Send(ctx context.Context) (*ListPlatformBranchesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPlatformBranchesResponse{
		ListPlatformBranchesOutput: r.Request.Data.(*ListPlatformBranchesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPlatformBranchesRequestPaginator returns a paginator for ListPlatformBranches.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPlatformBranchesRequest(input)
//   p := elasticbeanstalk.NewListPlatformBranchesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPlatformBranchesPaginator(req ListPlatformBranchesRequest) ListPlatformBranchesPaginator {
	return ListPlatformBranchesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPlatformBranchesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPlatformBranchesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPlatformBranchesPaginator struct {
	aws.Pager
}

func (p *ListPlatformBranchesPaginator) CurrentPage() *ListPlatformBranchesOutput {
	return p.Pager.CurrentPage().(*ListPlatformBranchesOutput)
}

// ListPlatformBranchesResponse is the response type for the
// ListPlatformBranches API operation.
type ListPlatformBranchesResponse struct {
	*ListPlatformBranchesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPlatformBranches request.
func (r *ListPlatformBranchesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
