// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type RestartAppServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to restart the server for.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to restart the server for.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s RestartAppServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestartAppServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestartAppServerInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestartAppServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestartAppServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestartAppServer = "RestartAppServer"

// RestartAppServerRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Causes the environment to restart the application container server running
// on each Amazon EC2 instance.
//
//    // Example sending a request using RestartAppServerRequest.
//    req := client.RestartAppServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer
func (c *Client) RestartAppServerRequest(input *RestartAppServerInput) RestartAppServerRequest {
	op := &aws.Operation{
		Name:       opRestartAppServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestartAppServerInput{}
	}

	req := c.newRequest(op, input, &RestartAppServerOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RestartAppServerRequest{Request: req, Input: input, Copy: c.RestartAppServerRequest}
}

// RestartAppServerRequest is the request type for the
// RestartAppServer API operation.
type RestartAppServerRequest struct {
	*aws.Request
	Input *RestartAppServerInput
	Copy  func(*RestartAppServerInput) RestartAppServerRequest
}

// Send marshals and sends the RestartAppServer API request.
func (r RestartAppServerRequest) Send(ctx context.Context) (*RestartAppServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestartAppServerResponse{
		RestartAppServerOutput: r.Request.Data.(*RestartAppServerOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestartAppServerResponse is the response type for the
// RestartAppServer API operation.
type RestartAppServerResponse struct {
	*RestartAppServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestartAppServer request.
func (r *RestartAppServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
