// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticinference

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAcceleratorOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The list of accelerator types to describe.
	AcceleratorTypes []string `locationName:"acceleratorTypes" type:"list"`

	// The location type that you want to describe accelerator type offerings for.
	// It can assume the following values: region: will return the accelerator type
	// offering at the regional level. availability-zone: will return the accelerator
	// type offering at the availability zone level. availability-zone-id: will
	// return the accelerator type offering at the availability zone level returning
	// the availability zone id.
	//
	// LocationType is a required field
	LocationType LocationType `locationName:"locationType" min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribeAcceleratorOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorOfferingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAcceleratorOfferingsInput"}
	if len(s.LocationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LocationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAcceleratorOfferingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AcceleratorTypes != nil {
		v := s.AcceleratorTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "acceleratorTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.LocationType) > 0 {
		v := s.LocationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "locationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type DescribeAcceleratorOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The list of accelerator type offerings for a specific location.
	AcceleratorTypeOfferings []AcceleratorTypeOffering `locationName:"acceleratorTypeOfferings" type:"list"`
}

// String returns the string representation
func (s DescribeAcceleratorOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAcceleratorOfferingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AcceleratorTypeOfferings != nil {
		v := s.AcceleratorTypeOfferings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "acceleratorTypeOfferings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeAcceleratorOfferings = "DescribeAcceleratorOfferings"

// DescribeAcceleratorOfferingsRequest returns a request value for making API operation for
// Amazon Elastic  Inference.
//
// Describes the locations in which a given accelerator type or set of types
// is present in a given region.
//
//    // Example sending a request using DescribeAcceleratorOfferingsRequest.
//    req := client.DescribeAcceleratorOfferingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorOfferings
func (c *Client) DescribeAcceleratorOfferingsRequest(input *DescribeAcceleratorOfferingsInput) DescribeAcceleratorOfferingsRequest {
	op := &aws.Operation{
		Name:       opDescribeAcceleratorOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-accelerator-offerings",
	}

	if input == nil {
		input = &DescribeAcceleratorOfferingsInput{}
	}

	req := c.newRequest(op, input, &DescribeAcceleratorOfferingsOutput{})

	return DescribeAcceleratorOfferingsRequest{Request: req, Input: input, Copy: c.DescribeAcceleratorOfferingsRequest}
}

// DescribeAcceleratorOfferingsRequest is the request type for the
// DescribeAcceleratorOfferings API operation.
type DescribeAcceleratorOfferingsRequest struct {
	*aws.Request
	Input *DescribeAcceleratorOfferingsInput
	Copy  func(*DescribeAcceleratorOfferingsInput) DescribeAcceleratorOfferingsRequest
}

// Send marshals and sends the DescribeAcceleratorOfferings API request.
func (r DescribeAcceleratorOfferingsRequest) Send(ctx context.Context) (*DescribeAcceleratorOfferingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAcceleratorOfferingsResponse{
		DescribeAcceleratorOfferingsOutput: r.Request.Data.(*DescribeAcceleratorOfferingsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAcceleratorOfferingsResponse is the response type for the
// DescribeAcceleratorOfferings API operation.
type DescribeAcceleratorOfferingsResponse struct {
	*DescribeAcceleratorOfferingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAcceleratorOfferings request.
func (r *DescribeAcceleratorOfferingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
